/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.communication.DocumentCommunicationEditor;

public abstract class AbstractDocumentCommunicationEditorTest<T extends DocumentCommunicationEditor>
extends AbstractIMObjectEditorTest<T> {
    public AbstractDocumentCommunicationEditorTest(Class<T> type, String archetype) {
        super(type, archetype);
    }

    @Test
    public void testEditMessage() {
        LocalContext local = new LocalContext();
        Party customer = TestHelper.createCustomer();
        local.setCustomer(customer);
        local.setPatient(TestHelper.createPatient((Party)customer));
        DefaultLayoutContext context = new DefaultLayoutContext((Context)local, new HelpContext("foo", null));
        DocumentAct act = (DocumentAct)this.newObject();
        IMObjectBean bean = this.getBean((IMObject)act);
        DocumentCommunicationEditor editor = (DocumentCommunicationEditor)this.createEditor((IMObject)act, (LayoutContext)context);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertFalse((boolean)editor.isModified());
        Assert.assertNull((Object)editor.getMessage());
        Assert.assertNull((Object)act.getDocument());
        Assert.assertNull((Object)bean.getString("message"));
        String text1 = StringUtils.repeat((String)"a", (int)5000);
        editor.setMessage(text1);
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertEquals((Object)text1, (Object)bean.getString("message"));
        Assert.assertNull((Object)act.getDocument());
        String text2 = text1 + "b";
        editor.setMessage(text2);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)bean.getString("message"));
        Reference document1 = act.getDocument();
        Assert.assertNotNull((Object)document1);
        this.checkDocument(document1, text2);
        String text3 = text2 + "c";
        editor.setMessage(text3);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)bean.getString("message"));
        Reference document2 = act.getDocument();
        Assert.assertEquals((Object)document1, (Object)document2);
        this.checkDocument(document2, text3);
        editor.setMessage("short");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)act.getDocument());
        Assert.assertNull((Object)this.get(document2));
        Assert.assertEquals((Object)"short", (Object)bean.getString("message"));
        editor.setMessage(text3);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)bean.getString("message"));
        Reference document3 = act.getDocument();
        Assert.assertNotNull((Object)document3);
        this.checkDocument(act.getDocument(), text3);
    }

    private void checkDocument(Reference documentRef, String text) {
        Document document = (Document)this.get(documentRef, Document.class);
        Assert.assertNotNull((Object)document);
        TextDocumentHandler handler = new TextDocumentHandler((ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)text, (Object)handler.toString(document));
    }
}

