/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.reminder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.impl.MacroTestHelper;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.workspace.customer.account.AccountReminderEvaluator;
import org.openvpms.web.workspace.customer.account.AccountReminderException;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountReminderEvaluatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private SMSTemplateEvaluator smsTemplateEvaluator;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    protected TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private AccountReminderEvaluator evaluator;
    private FinancialAct charge;
    private Party location;
    private Party practice;
    private Party customer;

    @Before
    public void setUp() {
        this.practice = (Party)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Vets R Us")).build(false);
        this.evaluator = new AccountReminderEvaluator(this.practice, this.smsTemplateEvaluator, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        this.customer = this.customerFactory.createCustomer("Foo", "Bar");
        this.location = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Vets R Us - Cowes")).build(false);
        this.charge = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).item().patient(this.patientFactory.createPatient(this.customer))).medicationProduct()).unitPrice(20)).add()).status("POSTED")).sendReminder(true)).startTime("2021-08-01")).build();
        ((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).till(this.practiceFactory.createTill())).cash(10).status("POSTED")).build();
        this.charge = (FinancialAct)this.get((IMObject)this.charge);
    }

    @Test
    public void testXPathExpression() {
        String expression = "concat('Dear ', $customer.firstName, ', your account from ', date:format($charge.startTime, 'EEEE dd/MM/yy'), ' at ', $location.name, ' has an outstanding balance of $', $balance)";
        Entity template = this.createXPathTemplate(expression);
        String value = this.evaluator.evaluate(template, this.charge, this.customer, this.location);
        Assert.assertEquals((Object)"Dear Foo, your account from Sunday 01/08/21 at Vets R Us - Cowes has an outstanding balance of $10", (Object)value);
    }

    @Test
    public void testXPathVariables() {
        this.checkXPathExpression("$charge.id", Long.toString(this.charge.getId()));
        this.checkXPathExpression("$balance", "10.00");
        this.checkXPathExpression("$location.name", "Vets R Us - Cowes");
        this.checkXPathExpression("$customer.firstName", "Foo");
        this.checkXPathExpression("$practice.name", "Vets R Us");
    }

    @Test
    public void testXPathException() {
        try {
            Entity template = this.createXPathTemplate("$badexpression");
            this.evaluator.evaluate(template, this.charge, this.location, this.practice);
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (AccountReminderException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the expression in Account Reminder SMS Template", (Object)expected.getMessage());
        }
    }

    @Test
    public void testMacroExpression() {
        MacroTestHelper.createMacro((String)"@customer", (String)"$customer.firstName");
        MacroTestHelper.createMacro((String)"@location", (String)"$location.name");
        MacroTestHelper.createMacro((String)"@startDate", (String)"date:format($charge.startTime, 'dd/MM/yy')");
        MacroTestHelper.createMacro((String)"@balance", (String)"concat('$', $balance)");
        String expression = "Dear @customer - your invoice from @startDate at @location has an outstanding balance of @balance";
        Entity template = this.createMacroTemplate(expression);
        String value = this.evaluator.evaluate(template, this.charge, this.customer, this.location);
        Assert.assertEquals((Object)"Dear Foo - your invoice from 01/08/21 at Vets R Us - Cowes has an outstanding balance of $10", (Object)value);
    }

    @Test
    public void testMacroException() {
        MacroTestHelper.createMacro((String)"@badexpression", (String)"concat(");
        try {
            Entity template = this.createMacroTemplate("@badexpression");
            this.evaluator.evaluate(template, this.charge, this.location, this.practice);
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (AccountReminderException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the expression in Account Reminder SMS Template", (Object)expected.getMessage());
        }
    }

    private void checkXPathExpression(String expression, String expected) {
        Entity template = this.createXPathTemplate(expression);
        String value = this.evaluator.evaluate(template, this.charge, this.customer, this.location);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    protected Entity createMacroTemplate(String template) {
        return this.createTemplate("MACRO", template);
    }

    protected Entity createXPathTemplate(String template) {
        return this.createTemplate("XPATH", template);
    }

    protected Entity createTemplate(String contentType, String template) {
        return (Entity)this.documentFactory.newSMSTemplate("entity.documentTemplateSMSAccount").contentType(contentType).content(template).build();
    }
}

