/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.customer.account.payment.PaymentChanges;

public class PaymentChangesTestCase
extends ArchetypeServiceTest {
    @Test
    public void testMessages() {
        FinancialAct cash1 = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct cheque1 = FinancialTestHelper.createPaymentCheque((BigDecimal)BigDecimal.TEN);
        FinancialAct credit1 = FinancialTestHelper.createPaymentCredit((BigDecimal)BigDecimal.TEN);
        FinancialAct discount1 = FinancialTestHelper.createPaymentDiscount((BigDecimal)BigDecimal.TEN);
        FinancialAct eft1 = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        FinancialAct other1 = FinancialTestHelper.createPaymentOther((BigDecimal)BigDecimal.TEN);
        this.save((IMObject[])new FinancialAct[]{cash1, cheque1, credit1, discount1, eft1, other1});
        FinancialAct cash2 = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct cheque2 = FinancialTestHelper.createPaymentCheque((BigDecimal)BigDecimal.TEN);
        FinancialAct credit2 = FinancialTestHelper.createPaymentCredit((BigDecimal)BigDecimal.TEN);
        FinancialAct discount2 = FinancialTestHelper.createPaymentDiscount((BigDecimal)BigDecimal.TEN);
        FinancialAct eft2 = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        FinancialAct other2 = FinancialTestHelper.createPaymentOther((BigDecimal)BigDecimal.TEN);
        this.checkMessage(cash1, cheque2, "Cash", "Cheque");
        this.checkMessage(cheque1, credit2, "Cheque", "Credit Card");
        this.checkMessage(credit1, discount2, "Credit Card", "Discount");
        this.checkMessage(discount1, eft2, "Discount", "EFT");
        this.checkMessage(eft1, other2, "EFT", "Other");
        this.checkMessage(other1, cash2, "Other", "Cash");
    }

    @Test
    public void testOnlyPersistentChangesRecorded() {
        PaymentChanges changes1 = new PaymentChanges(this.getArchetypeService());
        Assert.assertNull((Object)changes1.getAuditMessage("foo", new Date()));
        FinancialAct cash1 = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct cheque1 = FinancialTestHelper.createPaymentCheque((BigDecimal)BigDecimal.TEN);
        FinancialAct credit1 = FinancialTestHelper.createPaymentCredit((BigDecimal)BigDecimal.TEN);
        FinancialAct discount1 = FinancialTestHelper.createPaymentDiscount((BigDecimal)BigDecimal.TEN);
        FinancialAct ef1 = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        FinancialAct other1 = FinancialTestHelper.createPaymentOther((BigDecimal)BigDecimal.TEN);
        List acts = FinancialTestHelper.createPayment((Party)TestHelper.createCustomer(), (Entity)TestHelper.createTill(), (String)"POSTED", (FinancialAct[])new FinancialAct[]{cash1, cheque1, credit1, discount1, ef1, other1});
        this.save(acts);
        FinancialAct payment = (FinancialAct)acts.get(0);
        this.checkEquals(BigDecimal.valueOf(60L), payment.getTotal());
        FinancialAct discount2 = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct other2 = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct eft2 = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        changes1.addChange(cash1, discount2);
        changes1.addChange(discount2, other2);
        changes1.addChange(other2, eft2);
        Date datetime = TestHelper.getDatetime((String)"2020-02-13 12:30:00");
        String message = changes1.getAuditMessage("admin", datetime);
        Assert.assertEquals((Object)(DateFormatter.formatDateTime((Date)datetime) + " admin Cash ($10.00) \u21d2 EFT"), (Object)message);
        Assert.assertNull((Object)changes1.getAuditMessage("foo", new Date()));
    }

    @Test
    public void testMultipleChanges() {
        PaymentChanges changes = new PaymentChanges(this.getArchetypeService());
        FinancialAct cash = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN);
        FinancialAct cheque = FinancialTestHelper.createPaymentCheque((BigDecimal)BigDecimal.ONE);
        FinancialAct credit = FinancialTestHelper.createPaymentCredit((BigDecimal)BigDecimal.TEN);
        List acts = FinancialTestHelper.createPayment((Party)TestHelper.createCustomer(), (Entity)TestHelper.createTill(), (String)"POSTED", (FinancialAct[])new FinancialAct[]{cash, cheque, credit});
        this.save(acts);
        FinancialAct discount = FinancialTestHelper.createPaymentDiscount((BigDecimal)BigDecimal.TEN);
        FinancialAct other = FinancialTestHelper.createPaymentOther((BigDecimal)BigDecimal.ONE);
        FinancialAct eft = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        changes.addChange(cash, discount);
        changes.addChange(cheque, other);
        changes.addChange(credit, eft);
        Date datetime = TestHelper.getDatetime((String)"2020-02-13 12:30:00");
        String message = changes.getAuditMessage("admin", datetime);
        String date = DateFormatter.formatDateTime((Date)datetime);
        Assert.assertEquals((Object)(date + " admin Cash ($10.00) \u21d2 Discount\n" + date + " admin Cheque ($1.00) \u21d2 Other\n" + date + " admin Credit Card ($10.00) \u21d2 EFT"), (Object)message);
        Assert.assertNull((Object)changes.getAuditMessage("foo", new Date()));
    }

    private void checkMessage(FinancialAct oldPayment, FinancialAct newPayment, String from, String to) {
        PaymentChanges changes = new PaymentChanges(this.getArchetypeService());
        changes.addChange(oldPayment, newPayment);
        Date datetime = TestHelper.getDatetime((String)"2020-02-13 12:30:00");
        String message = changes.getAuditMessage("admin", datetime);
        String date = DateFormatter.formatDateTime((Date)datetime);
        String expected = date + " admin " + from + " (" + NumberFormatter.formatCurrency((Number)oldPayment.getTotal()) + ") \u21d2 " + to;
        Assert.assertEquals((Object)expected, (Object)message);
    }
}

