/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.ContactCollectionEditor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.CustomerEditor;
import org.openvpms.web.workspace.customer.PatientEntityRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.PatientOwnerRelationshipEditor;
import org.openvpms.web.workspace.patient.PatientEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomerEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Test
    public void testNewInstance() {
        Party customer = this.customerFactory.createCustomer();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        CustomerEditor editor = new CustomerEditor(customer, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof CustomerEditor));
    }

    @Test
    public void testAddNewPatient() {
        String species = this.lookupFactory.getSpecies("CANINE").getCode();
        Party customer = this.customerFactory.createCustomer();
        CustomerEditor editor = this.createEditor(customer);
        PatientEntityRelationshipCollectionEditor patientCollectionEditor = editor.getPatientCollectionEditor();
        Assert.assertNotNull((Object)patientCollectionEditor);
        EchoTestHelper.fireButton((Component)patientCollectionEditor.getComponent(), (String)"add");
        PatientOwnerRelationshipEditor relationshipEditor = (PatientOwnerRelationshipEditor)patientCollectionEditor.getCurrentEditor();
        Assert.assertNotNull((Object)relationshipEditor);
        EchoTestHelper.fireButton((Component)relationshipEditor.getComponent(), (String)"button.select");
        BrowserDialog patientBrowser = EchoTestHelper.findBrowserDialog();
        Assert.assertNotNull((Object)patientBrowser);
        EchoTestHelper.fireButton((Component)patientBrowser, (String)"new");
        EditDialog patientEditDialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)patientEditDialog);
        PatientEditor patientEditor = (PatientEditor)patientEditDialog.getEditor();
        patientEditor.getProperty("name").setValue((Object)"Fido");
        patientEditor.getProperty("species").setValue((Object)species);
        EchoTestHelper.fireButton((Component)patientBrowser, (String)"new");
        EchoTestHelper.fireButton((Component)patientEditDialog, (String)"ok");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        customer = (Party)this.get((IMObject)customer);
        IMObjectBean bean = this.getBean((IMObject)customer);
        List patients = bean.getTargets("patients", Party.class);
        Assert.assertEquals((long)1L, (long)patients.size());
        Assert.assertEquals(patients.get(0), (Object)patientEditor.getObject());
    }

    @Test
    public void testReferredBy() {
        this.lookupFactory.getLookup("lookup.customerReferral", "CUSTOMER");
        this.lookupFactory.getLookup("lookup.customerReferral", "GOOGLE");
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        CustomerEditor editor = this.createEditor(customer1);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setReferral("GOOGLE");
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setReferral("CUSTOMER");
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Referred by Customer is required");
        editor.setReferredByCustomer(customer1);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"The customer cannot refer themselves.\n\nSelect a different customer.");
        editor.setReferredByCustomer(customer2);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkReferral(customer1, "CUSTOMER", customer2);
        editor.setReferral("GOOGLE");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkReferral(customer1, "GOOGLE", null);
    }

    @Test
    public void testDelete() {
        Party referredBy = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Lookup tax = this.lookupFactory.createTaxType(BigDecimal.TEN);
        Party customer = (Party)this.customerFactory.newCustomer().referredBy("CUSTOMER").referredByCustomer(referredBy).addPatient(patient).addDiscounts(new Entity[]{discount}).addTaxExemptions(new String[]{tax.getCode()}).build();
        final CustomerEditor editor = this.createEditor(customer);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                editor.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)customer));
        Assert.assertNotNull((Object)this.get((IMObject)referredBy));
        Assert.assertNotNull((Object)this.get((IMObject)patient));
        Assert.assertNotNull((Object)this.get((IMObject)discount));
        Assert.assertNotNull((Object)this.get((IMObject)tax));
    }

    @Test
    public void testDefaultUnmodifiedContactsRemovedOnSaveForNewCustomer() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        CustomerEditor editor = this.createEditor(customer);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)customer.getContacts().isEmpty());
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertTrue((boolean)((Party)this.get((IMObject)customer)).getContacts().isEmpty());
    }

    @Test
    public void testDefaultUnmodifiedContactsRemovedOnSaveForExistingCustomer() {
        Party customer = (Party)this.customerFactory.newCustomer().addHomePhone("91234567").build();
        Assert.assertFalse((boolean)customer.isNew());
        Assert.assertEquals((long)1L, (long)customer.getContacts().size());
        CustomerEditor editor = this.createEditor(customer);
        ContactCollectionEditor contactsEditor = editor.getContacts();
        Assert.assertEquals((long)3L, (long)contactsEditor.getCurrentObjects().size());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkPhoneContact(contacts, "91234567", null);
    }

    @Test
    public void testModifyDefaultPhoneContact() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor phoneEditor = this.getContactEditor(editor, "contact.phoneNumber");
        phoneEditor.getProperty("telephoneNumber").setValue((Object)"123456789");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkPhoneContact(contacts, "123456789", null);
    }

    @Test
    public void testModifyExistingPhoneContact() {
        Party customer = (Party)this.customerFactory.newCustomer().addHomePhone("91234567").build();
        Contact phone = (Contact)IMObjectHelper.getObject((String)"contact.phoneNumber", (Collection)customer.getContacts());
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor phoneEditor = this.getContactEditor(editor, "contact.phoneNumber");
        phoneEditor.getProperty("telephoneNumber").setValue((Object)"123456789");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkPhoneContact(contacts, "123456789", phone);
    }

    @Test
    public void testModifyDefaultEmailContact() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        Assert.assertTrue((boolean)customer.getContacts().isEmpty());
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor emailEditor = this.getContactEditor(editor, "contact.email");
        emailEditor.getProperty("emailAddress").setValue((Object)"foo@bar.com");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkEmailContact(contacts, "foo@bar.com", null);
    }

    @Test
    public void testModifyExistingEmailContact() {
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).build();
        Contact email = (Contact)IMObjectHelper.getObject((String)"contact.email", (Collection)customer.getContacts());
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor emailEditor = this.getContactEditor(editor, "contact.email");
        emailEditor.getProperty("emailAddress").setValue((Object)"bar@foo.net");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkEmailContact(contacts, "bar@foo.net", email);
    }

    @Test
    public void testModifyDefaultLocationContact() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        Assert.assertTrue((boolean)customer.getContacts().isEmpty());
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor locationEditor = this.getContactEditor(editor, "contact.location");
        locationEditor.getProperty("address").setValue((Object)"1 Main St");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkLocationContact(contacts, "1 Main St", null);
    }

    @Test
    public void testModifyExistingLocationContact() {
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().newLocation().address("1 Main St").add()).build();
        Contact location = (Contact)IMObjectHelper.getObject((String)"contact.location", (Collection)customer.getContacts());
        CustomerEditor editor = this.createEditor(customer);
        Assert.assertEquals((long)3L, (long)editor.getContacts().getCurrentObjects().size());
        IMObjectEditor locationEditor = this.getContactEditor(editor, "contact.location");
        locationEditor.getProperty("address").setValue((Object)"32 High St");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)1L, (long)contacts.size());
        this.checkLocationContact(contacts, "32 High St", location);
    }

    @Test
    public void testDeleteModifiedDefaultContact() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        CustomerEditor editor = this.createEditor(customer);
        ContactCollectionEditor contacts = editor.getContacts();
        Assert.assertEquals((long)3L, (long)contacts.getCurrentObjects().size());
        IMObjectEditor locationEditor = this.getContactEditor(editor, "contact.location");
        locationEditor.getProperty("address").setValue((Object)"1 Main St");
        contacts.remove(locationEditor.getObject());
        Assert.assertEquals((long)2L, (long)contacts.getCurrentObjects().size());
        Assert.assertEquals((long)2L, (long)contacts.getEditors().size());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertTrue((boolean)((Party)this.get((IMObject)customer)).getContacts().isEmpty());
    }

    @Test
    public void testEditExistingContacts() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).newLocation().address("1 Main St").add()).addHomePhone("12345678").build();
        Contact email = (Contact)IMObjectHelper.getObject((String)"contact.email", (Collection)customer.getContacts());
        Contact location = (Contact)IMObjectHelper.getObject((String)"contact.location", (Collection)customer.getContacts());
        Contact phone = (Contact)IMObjectHelper.getObject((String)"contact.phoneNumber", (Collection)customer.getContacts());
        CustomerEditor editor = this.createEditor(customer);
        ContactCollectionEditor contactsEditor = editor.getContacts();
        Assert.assertEquals((long)3L, (long)contactsEditor.getCurrentObjects().size());
        IMObjectEditor emailEditor = this.getContactEditor(editor, "contact.email");
        emailEditor.getProperty("emailAddress").setValue((Object)"bar@foo.com");
        IMObjectEditor locationEditor = this.getContactEditor(editor, "contact.location");
        locationEditor.getProperty("address").setValue((Object)"32 High St");
        IMObjectEditor phoneEditor = this.getContactEditor(editor, "contact.phoneNumber");
        phoneEditor.getProperty("telephoneNumber").setValue((Object)"987654321");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)3L, (long)contacts.size());
        this.checkEmailContact(contacts, "bar@foo.com", email);
        this.checkLocationContact(contacts, "32 High St", location);
        this.checkPhoneContact(contacts, "987654321", phone);
    }

    @Test
    public void testMultipleContactsOfSameType() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        CustomerEditor editor = this.createEditor(customer);
        ContactCollectionEditor contactsEditor = editor.getContacts();
        Assert.assertEquals((long)3L, (long)contactsEditor.getCurrentObjects().size());
        IMObjectEditor locationEditor1 = this.getContactEditor(editor, "contact.location");
        locationEditor1.getProperty("address").setValue((Object)"32 High St");
        IMObjectEditor locationEditor2 = contactsEditor.add("contact.location");
        locationEditor2.getProperty("address").setValue((Object)"1 Main St");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Set contacts = ((Party)this.get((IMObject)customer)).getContacts();
        Assert.assertEquals((long)2L, (long)contacts.size());
        this.checkAddressExists(contacts, "32 High St");
        this.checkAddressExists(contacts, "1 Main St");
    }

    private void checkAddressExists(Set<Contact> contacts, String address) {
        long found = contacts.stream().filter(object -> object.isA("contact.location") && address.equals(this.getBean((IMObject)object).getString("address"))).count();
        Assert.assertEquals((long)1L, (long)found);
    }

    private IMObjectEditor getContactEditor(CustomerEditor editor, String archetype) {
        IMObject contact = IMObjectHelper.getObject((String)archetype, (Collection)editor.getContacts().getCurrentObjects());
        Assert.assertNotNull((Object)contact);
        IMObjectEditor contactEditor = editor.getContacts().getEditor(contact);
        Assert.assertNotNull((Object)contactEditor);
        return contactEditor;
    }

    private void checkPhoneContact(Set<Contact> contacts, String phone, Contact existing) {
        Contact contact = (Contact)IMObjectHelper.getObject((String)"contact.phoneNumber", contacts);
        Assert.assertNotNull((Object)contact);
        IMObjectBean bean = this.getBean((IMObject)contact);
        Assert.assertEquals((Object)phone, (Object)bean.getString("telephoneNumber"));
        if (existing != null) {
            Assert.assertEquals((Object)existing, (Object)contact);
        }
    }

    private void checkEmailContact(Set<Contact> contacts, String email, Contact existing) {
        Contact contact = (Contact)IMObjectHelper.getObject((String)"contact.email", contacts);
        Assert.assertNotNull((Object)contact);
        IMObjectBean bean = this.getBean((IMObject)contact);
        Assert.assertEquals((Object)email, (Object)bean.getString("emailAddress"));
        if (existing != null) {
            Assert.assertEquals((Object)existing, (Object)contact);
        }
    }

    private void checkLocationContact(Set<Contact> contacts, String address, Contact existing) {
        Contact contact = (Contact)IMObjectHelper.getObject((String)"contact.location", contacts);
        Assert.assertNotNull((Object)contact);
        IMObjectBean bean = this.getBean((IMObject)contact);
        Assert.assertEquals((Object)address, (Object)bean.getString("address"));
        if (existing != null) {
            Assert.assertEquals((Object)existing, (Object)contact);
        }
    }

    private void checkReferral(Party customer, String referral, Party referredBy) {
        IMObjectBean bean = this.getBean(this.get((IMObject)customer));
        Assert.assertEquals((Object)referral, (Object)bean.getString("referral"));
        Assert.assertEquals((Object)referredBy, (Object)bean.getTarget("referredByCustomer"));
    }

    private CustomerEditor createEditor(Party customer) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        CustomerEditor editor = new CustomerEditor(customer, null, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }
}

