/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.organisation.OrganisationLocationDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class OrganisationLocationDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDelete() {
        Party location = TestHelper.createLocation();
        Document document = (Document)this.documentFactory.createJRXML();
        DocumentAct act = (DocumentAct)this.create("act.documentLogo", DocumentAct.class);
        act.setDocument((Reference)document.getObjectReference());
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("owner", (IMObject)location);
        this.save((IMObject[])new AuditableIMObject[]{location, act, document});
        OrganisationLocationDeletionHandler handler = this.createDeletionHandler(location);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)location));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Party location = TestHelper.createLocation();
        IMObjectDeletionHandler handler = factory.create((IMObject)location);
        Assert.assertTrue((boolean)(handler instanceof OrganisationLocationDeletionHandler));
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)location));
    }

    protected OrganisationLocationDeletionHandler createDeletionHandler(Party location) {
        return new OrganisationLocationDeletionHandler(location, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

