/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.account;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.job.account.TestAccountReminderJobBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.job.account.AccountReminderJobEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountReminderJobEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testDelete() {
        Entity template = (Entity)this.documentFactory.newSMSTemplate("entity.documentTemplateSMSAccount").content("TEXT").content("Sample").build();
        User user = this.userFactory.createUser();
        TestAccountReminderJobBuilder builder = new TestAccountReminderJobBuilder((ArchetypeService)this.getArchetypeService());
        Entity job = (Entity)((TestAccountReminderJobBuilder)builder.count(2, DateUnits.DAYS, template).count(4, DateUnits.WEEKS, template).runAs(user)).build();
        Assert.assertEquals((long)2L, (long)builder.getCounts().size());
        Entity count1 = (Entity)builder.getCounts().get(0);
        Entity count2 = (Entity)builder.getCounts().get(1);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AccountReminderJobEditor editor = new AccountReminderJobEditor(job, null, (LayoutContext)context);
        editor.delete();
        Assert.assertNull((Object)this.get((IMObject)job));
        Assert.assertNull((Object)this.get((IMObject)count1));
        Assert.assertNull((Object)this.get((IMObject)count2));
        Assert.assertNotNull((Object)this.get((IMObject)template));
        Assert.assertNotNull((Object)this.get((IMObject)user));
    }

    @Test
    public void testNewInstance() {
        Entity job = (Entity)this.create("entity.jobAccountReminder", Entity.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AccountReminderJobEditor editor = new AccountReminderJobEditor(job, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof AccountReminderJobEditor));
        Assert.assertEquals((Object)job, (Object)newInstance.getObject());
    }

    @Test
    public void testFactory() {
        Entity job = (Entity)this.create("entity.jobAccountReminder", Entity.class);
        IMObjectEditor editor = this.factory.create((IMObject)job, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof AccountReminderJobEditor));
    }
}

