/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.hl7.TestHL7Factory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.hl7.HL7PharmacyEditor;
import org.openvpms.web.workspace.admin.role.RoleEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class HL7PharmacyEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestHL7Factory hl7Factory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private IMObjectEditorFactory factory;

    @Test
    public void testOneway() {
        Entity pharmacy = (Entity)this.hl7Factory.newHL7Pharmacy().defaultSenderReceiver().location(this.practiceFactory.createLocation()).user(this.userFactory.createUser()).build();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        HL7PharmacyEditor editor = new HL7PharmacyEditor(pharmacy, null, (LayoutContext)context);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        editor.getProperty("oneway").setValue((Object)true);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Cannot specify a Dispense Connector when One Way is selected.");
    }

    @Test
    public void testNewInstance() {
        Entity pharmacy = (Entity)this.create("entity.HL7ServicePharmacy", Entity.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        HL7PharmacyEditor editor = new HL7PharmacyEditor(pharmacy, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof HL7PharmacyEditor));
    }

    @Test
    public void testFactory() {
        SecurityRole role = (SecurityRole)this.create("security.role", SecurityRole.class);
        IMObjectEditor editor = this.factory.create((IMObject)role, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof RoleEditor));
    }
}

