/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class ContextDocumentTemplateLocatorTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    private Party practice;
    private Party location;
    private Entity template1;
    private Entity template2;
    private Entity defaultTemplate;

    @Before
    public void setUp() {
        super.setUp();
        this.practice = TestHelper.getPractice();
        IMObjectBean bean = this.getBean((IMObject)this.practice);
        bean.removeValues("templates");
        this.location = TestHelper.createLocation();
        this.template1 = (Entity)this.documentFactory.newTemplate().type("act.patientDocumentForm").printer().printer("test1").location(this.practice).add().build();
        this.template2 = (Entity)this.documentFactory.newTemplate().type("act.patientDocumentForm").printer().printer("test2").location(this.location).add().build();
        this.defaultTemplate = this.getDefaultTemplate("act.patientDocumentForm");
    }

    @Test
    public void testObjectContext() {
        IMObject object = this.create("act.patientDocumentForm");
        Context context1 = this.createContext(null, null);
        ContextDocumentTemplateLocator locator1 = new ContextDocumentTemplateLocator(object, context1);
        this.checkTemplate(this.defaultTemplate, (DocumentTemplateLocator)locator1);
        Context context2 = this.createContext(this.practice, null);
        ContextDocumentTemplateLocator locator2 = new ContextDocumentTemplateLocator(object, context2);
        this.checkTemplate(this.template1, (DocumentTemplateLocator)locator2);
        Context context3 = this.createContext(null, this.location);
        ContextDocumentTemplateLocator locator3 = new ContextDocumentTemplateLocator(object, context3);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator3);
        Context context4 = this.createContext(this.practice, this.location);
        ContextDocumentTemplateLocator locator4 = new ContextDocumentTemplateLocator(object, context4);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator4);
    }

    @Test
    public void testShortNameContext() {
        Context context1 = this.createContext(null, null);
        ContextDocumentTemplateLocator locator1 = new ContextDocumentTemplateLocator("act.patientDocumentForm", context1);
        this.checkTemplate(this.defaultTemplate, (DocumentTemplateLocator)locator1);
        Context context2 = this.createContext(this.practice, null);
        ContextDocumentTemplateLocator locator2 = new ContextDocumentTemplateLocator("act.patientDocumentForm", context2);
        this.checkTemplate(this.template1, (DocumentTemplateLocator)locator2);
        Context context3 = this.createContext(null, this.location);
        ContextDocumentTemplateLocator locator3 = new ContextDocumentTemplateLocator("act.patientDocumentForm", context3);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator3);
        Context context4 = this.createContext(this.practice, this.location);
        ContextDocumentTemplateLocator locator4 = new ContextDocumentTemplateLocator("act.patientDocumentForm", context4);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator4);
    }

    @Test
    public void testTemplateObjectContext() {
        IMObject object = this.create("act.patientDocumentForm");
        DocumentTemplate template3 = this.createDocumentTemplate("act.patientDocumentForm");
        Context context1 = this.createContext(null, null);
        ContextDocumentTemplateLocator locator1 = new ContextDocumentTemplateLocator(template3, object, context1);
        Assert.assertEquals((Object)template3, (Object)locator1.getTemplate());
        Context context2 = this.createContext(this.practice, null);
        ContextDocumentTemplateLocator locator2 = new ContextDocumentTemplateLocator(null, object, context2);
        this.checkTemplate(this.template1, (DocumentTemplateLocator)locator2);
    }

    @Test
    public void testTemplateShortNameContext() {
        DocumentTemplate template3 = this.createDocumentTemplate("act.patientDocumentForm");
        Context empty = this.createContext(null, null);
        ContextDocumentTemplateLocator locator1 = new ContextDocumentTemplateLocator(template3, "act.patientDocumentForm", empty);
        Assert.assertEquals((Object)template3, (Object)locator1.getTemplate());
        ContextDocumentTemplateLocator locator2 = new ContextDocumentTemplateLocator(null, "act.patientDocumentForm", empty);
        this.checkTemplate(this.defaultTemplate, (DocumentTemplateLocator)locator2);
        Context context = this.createContext(null, this.location);
        ContextDocumentTemplateLocator locator3 = new ContextDocumentTemplateLocator(null, "act.patientDocumentForm", context);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator3);
    }

    @Test
    public void testInactiveTemplate() {
        Context context = this.createContext(this.practice, this.location);
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.patientDocumentForm", context);
        this.checkTemplate(this.template2, (DocumentTemplateLocator)locator);
        this.template2.setActive(false);
        this.save((IMObject)this.template2);
        this.checkTemplate(this.template1, (DocumentTemplateLocator)locator);
        this.template1.setActive(false);
        this.save((IMObject)this.template1);
        if (this.defaultTemplate != null) {
            if (!Objects.equals(this.defaultTemplate, this.template1) && !Objects.equals(this.defaultTemplate, this.template2)) {
                this.checkTemplate(this.defaultTemplate, (DocumentTemplateLocator)locator);
                this.defaultTemplate.setActive(false);
                this.save((IMObject)this.defaultTemplate);
                Entity newDefaultTemplate = this.getDefaultTemplate("act.patientDocumentForm");
                if (newDefaultTemplate != null) {
                    Assert.assertTrue((boolean)newDefaultTemplate.isActive());
                }
                this.checkTemplate(newDefaultTemplate, (DocumentTemplateLocator)locator);
                if (this.defaultTemplate != null) {
                    Assert.assertNotEquals((Object)this.defaultTemplate, (Object)newDefaultTemplate);
                }
            }
        } else {
            Assert.assertNull((Object)locator.getTemplate());
        }
    }

    private void checkTemplate(Entity expected, DocumentTemplateLocator locator) {
        DocumentTemplate template = null;
        if (expected != null) {
            template = new DocumentTemplate(expected, (ArchetypeService)this.getArchetypeService());
        }
        this.checkTemplate(template, locator);
    }

    private void checkTemplate(DocumentTemplate expected, DocumentTemplateLocator locator) {
        Assert.assertEquals((Object)expected, (Object)locator.getTemplate());
    }

    private DocumentTemplate createDocumentTemplate(String type) {
        Entity template = (Entity)this.documentFactory.newTemplate().type(type).build();
        return new DocumentTemplate(template, (ArchetypeService)this.getArchetypeService());
    }

    private Context createContext(Party practice, Party location) {
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        context.setLocation(location);
        return context;
    }

    private Entity getDefaultTemplate(String shortName) {
        TemplateHelper helper = new TemplateHelper((ArchetypeService)ServiceHelper.getArchetypeService());
        return helper.getTemplateForType(shortName);
    }
}

