/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.reporting.payment;

import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.workspace.reporting.account.AccountActQuery;

/**
 * Payments query.
 *
 * @author Tim Anderson
 */
public abstract class AbstractPaymentsQuery extends AccountActQuery {

    /**
     * The archetypes to query.
     */
    static final String[] ARCHETYPES = {CustomerAccountArchetypes.PAYMENT, CustomerAccountArchetypes.REFUND};

    /**
     * Constructs an {@link AbstractPaymentsQuery}.
     *
     * @param statuses the statuses to query
     * @param location the initial location to filter on. May be {@code null}
     * @param searchFilter    if {@code true}, add a search filter
     * @param amountFilter    if {@code true}, add an amount filter
     * @param context  the layout context
     */
    public AbstractPaymentsQuery(ActStatuses statuses, Party location, boolean searchFilter, boolean amountFilter,
                                 LayoutContext context) {
        super(ARCHETYPES, statuses, location, searchFilter, false, amountFilter, context);
    }
}