/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer.payment;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;

/**
 * Layout strategy for <em>act.paymentProcessorPayment</em> and <em>act.paymentProcessorRefund</em> acts.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorTransactionLayoutStrategy extends AbstractLayoutStrategy {

    /**
     * Constructs an {@link PaymentProcessorTransactionLayoutStrategy}.
     */
    public PaymentProcessorTransactionLayoutStrategy() {
        super(new ArchetypeNodes().excludeIfEmpty("url"));
    }

    /**
     * Apply the layout strategy.
     * <p>
     * This renders an object in a {@code Component}, using a factory to create the child components.
     *
     * @param object     the object to apply
     * @param properties the object's properties
     * @param parent     the parent object. May be {@code null}
     * @param context    the layout context
     * @return the component containing the rendered {@code object}
     */
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property url = properties.get("url");
        if (url.getString() != null) {
            // limit the url to 1 line
            Component urlComponent = context.getComponentFactory().create(url, Hint.height(1));
            addComponent(new ComponentState(urlComponent, url));
        }
        Property message = properties.get("message");
        addComponent(createMultiLineText(message, 1, 5, new Extent(50, Extent.EX), context));
        return super.apply(object, properties, parent, context);
    }
}