/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.test;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.math.NumberUtils;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.Jetty9xExistingLocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty9xInstalledLocalContainer;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.security.TestFirewallBuilder;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.booking.domain.Booking;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.component.business.domain.im.plugin.Plugin;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.ws.util.ErrorResponseFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class FirewallIntegrationTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private PluginDAO pluginDAO;
    private int port;
    private User user1;
    private User user2;
    private User user3;
    private InstalledLocalContainer container;
    private TestFirewallBuilder firewallBuilder;

    @Before
    public void setUp() throws Exception {
        this.practiceFactory.newPractice().enablePlugins().build();
        this.firewallBuilder = new TestFirewallBuilder((ArchetypeService)this.getArchetypeService());
        this.installPlugins();
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        ArchetypeAwareGrantedAuthority createAll = this.userFactory.createAuthority("create", "*.*");
        ArchetypeAwareGrantedAuthority saveAll = this.userFactory.createAuthority("save", "*.*");
        SecurityRole role = this.userFactory.createRole(new ArchetypeAwareGrantedAuthority[]{createAll, saveAll});
        this.user1 = (User)((TestUserBuilder)this.userFactory.newUser().connectFromAnywhere(true).password(encoder.encode((CharSequence)"password1")).addEmail("foo@bar.com", new String[0])).onlineBooking().addRoles(new SecurityRole[]{role}).build();
        this.user2 = (User)((TestUserBuilder)this.userFactory.newUser().connectFromAnywhere(false).password(encoder.encode((CharSequence)"password2")).addEmail("bar@foo.com", new String[0])).onlineBooking().addRoles(new SecurityRole[]{role}).build();
        this.user3 = (User)((TestUserBuilder)this.userFactory.newUser().connectFromAnywhere(true).changePassword(true).password(encoder.encode((CharSequence)"password3")).addEmail("gum@ball.com", new String[0])).onlineBooking().addRoles(new SecurityRole[]{role}).build();
    }

    @After
    public void tearDown() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    @Test
    public void testUnrestrictedAccess() {
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.firewallBuilder.accessType(FirewallSettings.AccessType.UNRESTRICTED).allowedAddresses(new String[0]).build();
        this.startJetty();
        this.checkUnrestrictedAccess(address1, address2, this.user1, this.user2, this.user3);
    }

    @Test
    public void testAllowedOnly() {
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.firewallBuilder.accessType(FirewallSettings.AccessType.ALLOWED_ONLY).allowedAddresses(new String[]{address1}).build();
        this.startJetty();
        this.checkAllowedOnly(address1, address2, this.user1, this.user2, this.user3);
    }

    @Test
    public void testAllowedUser() {
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.firewallBuilder.accessType(FirewallSettings.AccessType.ALLOWED_USER).allowedAddresses(new String[]{address1}).enableMultifactorAuthentication(true).build();
        this.startJetty();
        this.checkAllowedUser(address1, address2, this.user1, this.user2, this.user3);
    }

    @Test
    public void testOnlineBookingWithUnrestrictedAccess() {
        this.firewallBuilder.accessType(FirewallSettings.AccessType.UNRESTRICTED).build();
        Booking booking1 = this.createBooking(9);
        Booking booking2 = this.createBooking(10);
        Booking booking3 = this.createBooking(11);
        Booking booking4 = this.createBooking(12);
        Booking booking5 = this.createBooking(13);
        this.startJetty();
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.checkSubmitBooking(booking1, this.user1, "password1", address1);
        this.checkSubmitBooking(booking2, this.user1, "password1", address2);
        this.checkSubmitBooking(booking3, this.user2, "password2", address1);
        this.checkSubmitBooking(booking4, this.user2, "password2", address2);
        this.checkSubmitBookingFails(booking5, this.user3, "password3", address1);
    }

    @Test
    public void testOnlineBookingWithAllowedOnlyFirewallAccess() {
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.firewallBuilder.accessType(FirewallSettings.AccessType.ALLOWED_ONLY).allowedAddresses(new String[]{address1}).build();
        Booking booking1 = this.createBooking(9);
        Booking booking2 = this.createBooking(10);
        Booking booking3 = this.createBooking(11);
        Booking booking4 = this.createBooking(12);
        Booking booking5 = this.createBooking(13);
        this.startJetty();
        this.checkSubmitBooking(booking1, this.user1, "password1", address1);
        this.checkSubmitBooking(booking2, this.user2, "password2", address1);
        this.checkSubmitBookingFails(booking3, this.user1, "password1", address2);
        this.checkSubmitBookingFails(booking4, this.user2, "password2", address2);
        this.checkSubmitBookingFails(booking5, this.user3, "password3", address1);
    }

    @Test
    public void testOnlineBookingWithAllowedUserFirewallAccess() {
        String address1 = "127.0.0.1";
        String address2 = "192.168.1.1";
        this.firewallBuilder.accessType(FirewallSettings.AccessType.ALLOWED_USER).allowedAddresses(new String[]{address1}).enableMultifactorAuthentication(true).build();
        Booking booking1 = this.createBooking(9);
        Booking booking2 = this.createBooking(10);
        Booking booking3 = this.createBooking(11);
        Booking booking4 = this.createBooking(12);
        Booking booking5 = this.createBooking(13);
        this.startJetty();
        this.checkSubmitBooking(booking1, this.user1, "password1", address1);
        this.checkSubmitBooking(booking2, this.user2, "password2", address1);
        this.checkSubmitBooking(booking3, this.user1, "password1", address2);
        this.checkSubmitBookingFails(booking4, this.user2, "password2", address2);
        this.checkSubmitBookingFails(booking5, this.user3, "password3", address1);
    }

    protected void checkUnrestrictedAccess(String address1, String address2, User user1, User user2, User user3) {
        this.checkGet("/openvpms/login", address1, 200);
        this.checkGet("/openvpms/login", address2, 200);
        this.checkGet("/openvpms/forgotpassword", address1, 200);
        this.checkGet("/openvpms/forgotpassword", address2, 200);
        this.checkGet("/openvpms/resetpassword", address1, 200);
        this.checkGet("/openvpms/resetpassword", address2, 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address1, 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address2, 401);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address1, 200);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address2, 200);
        this.checkGet("/openvpms/rest/hello/1/hello", address1, 200);
        this.checkGet("/openvpms/rest/hello/1/hello", address2, 200);
    }

    protected void checkAllowedOnly(String address1, String address2, User user1, User user2, User user3) {
        this.checkGet("/openvpms/login", address1, 200);
        this.checkGet("/openvpms/login", address2, 401);
        this.checkGet("/openvpms/forgotpassword", address1, 200);
        this.checkGet("/openvpms/forgotpassword", address2, 401);
        this.checkGet("/openvpms/resetpassword", address1, 200);
        this.checkGet("/openvpms/resetpassword", address2, 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "password1", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "password1", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user2.getUsername(), "password2", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user2.getUsername(), "password2", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address1, 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address2, 401);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address1, 200);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address2, 401);
        this.checkGet("/openvpms/rest/hello/1/hello", address1, 200);
        this.checkGet("/openvpms/rest/hello/1/hello", address2, 401);
    }

    protected void checkAllowedUser(String address1, String address2, User user1, User user2, User user3) {
        this.checkGet("/openvpms/login", address1, 200);
        this.checkGet("/openvpms/login", address2, 200);
        this.checkGet("/openvpms/forgotpassword", address1, 200);
        this.checkGet("/openvpms/forgotpassword", address2, 200);
        this.checkGet("/openvpms/resetpassword", address1, 200);
        this.checkGet("/openvpms/resetpassword", address2, 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "password1", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user2.getUsername(), "password2", 200);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user2.getUsername(), "password2", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user2.getUsername(), "password2", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user1.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address1, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "password3", 401);
        this.checkGet("/openvpms/ws/booking/v1/locations", address1, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/ws/booking/v2/locations", address2, user3.getUsername(), "incorrect", 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address1, 401);
        this.checkGet("/openvpms/webdav/12345/67890/foo.odt", address2, 401);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address1, 200);
        this.checkGet("/openvpms/plugins/servlet/test-servlet", address2, 200);
        this.checkGet("/openvpms/rest/hello/1/hello", address1, 200);
        this.checkGet("/openvpms/rest/hello/1/hello", address2, 200);
    }

    protected void checkGet(String path, String remoteAddr, int status) {
        String url = "http://localhost:" + this.port + path;
        ((ValidatableResponse)((Response)RestAssured.given().header("X-Forwarded-For", (Object)remoteAddr, new Object[0]).get(url, new Object[0])).then()).statusCode(status);
    }

    protected void checkGet(String path, String remoteAddr, String username, String password, int status) {
        String url = "http://localhost:" + this.port + path;
        ((ValidatableResponse)((Response)RestAssured.given().header("X-Forwarded-For", (Object)remoteAddr, new Object[0]).auth().basic(username, password).get(url, new Object[0])).then()).statusCode(status);
    }

    protected void startJetty() {
        this.startJetty(null);
    }

    protected void startJettyDebug() {
        String jvmArgs = "-Xdebug\n-Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=openvpms_dev\n-Xnoagent\n-Djava.compiler=NONE";
        this.startJetty(jvmArgs);
    }

    protected void startJetty(String jvmArgs) {
        Jetty9xExistingLocalConfiguration configuration = new Jetty9xExistingLocalConfiguration(this.getPath("target/jetty"));
        configuration.addDeployable((Deployable)new WAR(this.getPath("target/openvpms.war")));
        configuration.setProperty("cargo.logging", LoggingLevel.HIGH.getLevel());
        if (jvmArgs != null) {
            configuration.setProperty("cargo.jvmargs", jvmArgs);
        }
        this.container = new Jetty9xInstalledLocalContainer((LocalConfiguration)configuration);
        this.container.setHome(this.getPath("target/jetty"));
        this.container.setOutput("target/cargo.log");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openvpms.key", System.getProperty("openvpms.key"));
        properties.put("db.url", System.getProperty("db.url"));
        properties.put("catalina.base", ".");
        this.container.setSystemProperties(properties);
        this.container.start();
        this.port = Integer.parseInt(this.container.getConfiguration().getPropertyValue("cargo.servlet.port"));
        System.out.println("Jetty listening on port " + this.port);
    }

    private void checkSubmitBooking(Booking booking, User user, String password, String address) {
        ClientConfig config = new ClientConfig().register(JacksonFeature.class).register((Object)HttpAuthenticationFeature.basic((String)user.getUsername(), (String)password)).register((Object)new ErrorResponseFilter());
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget target = client.target("http://localhost:" + this.port + "/openvpms/ws/booking/v2/bookings");
        String response = (String)target.request().header("X-Forwarded-For", (Object)address).post(Entity.entity((Object)booking, (MediaType)MediaType.APPLICATION_JSON_TYPE), String.class);
        Assert.assertNotNull((Object)response);
        String[] tokens = response.split(":");
        Assert.assertEquals((long)2L, (long)tokens.length);
        long id = NumberUtils.toLong((String)tokens[0], (long)-1L);
        Act act = (Act)this.getArchetypeService().get("act.customerAppointment", id, Act.class);
        Assert.assertNotNull((Object)act);
        Assert.assertEquals((Object)user.getObjectReference(), (Object)act.getCreatedBy());
    }

    private void checkSubmitBookingFails(Booking booking, User user, String password, String address) {
        try {
            this.checkSubmitBooking(booking, user, password, address);
            Assert.fail((String)"Expected checkSubmitBooking() to fail");
        }
        catch (NotAuthorizedException expected) {
            Assert.assertEquals((Object)"HTTP 401 Unauthorized", (Object)expected.getMessage());
        }
    }

    private Booking createBooking(int startHour) {
        Party location = (Party)this.practiceFactory.newLocation().onlineBooking().build();
        org.openvpms.component.model.entity.Entity appointmentType = (org.openvpms.component.model.entity.Entity)this.schedulingFactory.newAppointmentType().onlineBooking().build();
        org.openvpms.component.model.entity.Entity schedule = (org.openvpms.component.model.entity.Entity)this.schedulingFactory.newSchedule().location(location).appointmentTypes(new org.openvpms.component.model.entity.Entity[]{appointmentType}).onlineBooking().build();
        Booking booking = new Booking();
        booking.setLocation(location.getId());
        booking.setSchedule(schedule.getId());
        booking.setUser(this.userFactory.createClinician().getId());
        booking.setAppointmentType(appointmentType.getId());
        Date date = DateRules.getTomorrow();
        booking.setStart(DateRules.getDate((Date)date, (int)startHour, (DateUnits)DateUnits.HOURS));
        booking.setEnd(DateRules.getDate((Date)date, (int)(startHour + 1), (DateUnits)DateUnits.HOURS));
        booking.setTitle("Ms");
        booking.setFirstName("Foo");
        booking.setLastName("Bar");
        booking.setEmail("foo@bar.com");
        booking.setMobile("0412345678");
        booking.setPatientName("Fido");
        return booking;
    }

    private String getPath(String path) {
        return new File(path).getAbsolutePath();
    }

    private void installPlugins() throws Exception {
        Iterator plugins = this.pluginDAO.getPlugins();
        while (plugins.hasNext()) {
            this.pluginDAO.remove(((Plugin)plugins.next()).getKey());
        }
        this.installPlugin("org.openvpms.openvpms-test-rest-plugin", "openvpms-test-rest-plugin.jar");
        this.installPlugin("org.openvpms.openvpms-test-servlet-plugin", "openvpms-test-servlet-plugin.jar");
    }

    private void installPlugin(String key, String name) throws Exception {
        String path = "target/" + name;
        try (FileInputStream file = new FileInputStream(path);){
            this.pluginDAO.save(key, name, (InputStream)file);
        }
    }
}

