/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.user;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.web.security.user.LoginUserDetails;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class LoginUserDetailsImpl
implements LoginUserDetails {
    private final User user;
    private final String email;
    private final boolean isTOTPConfigured;
    private final Set<GrantedAuthority> authorities;
    private boolean mfaRequired;

    public LoginUserDetailsImpl(User user, String email, boolean isTOTPConfigured) {
        this(user, email, isTOTPConfigured, "ROLE_USER");
    }

    public LoginUserDetailsImpl(User user, String email, boolean isTOTPConfigured, String role) {
        this.user = user;
        this.email = email;
        this.isTOTPConfigured = isTOTPConfigured;
        this.authorities = new TreeSet<GrantedAuthority>(Comparator.comparing(GrantedAuthority::getAuthority));
        this.authorities.addAll(user.getAuthorities());
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
    }

    @Override
    public UserDetails getUserDetails() {
        return this.user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.user.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.user.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.user.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setMultiFactorAuthenticationRequired() {
        this.mfaRequired = true;
    }

    @Override
    public boolean isMultiFactorAuthenticationRequired() {
        return this.mfaRequired;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isTOTPConfigured() {
        return this.isTOTPConfigured;
    }
}

