/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openvpms.web.security.login.ConfirmForgotPasswordServlet;
import org.openvpms.web.security.login.PasswordService;
import org.openvpms.web.security.login.SecurityCodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ConfirmResetPasswordServlet
extends HttpServlet {
    private PasswordService passwordResetService;
    private static final Logger log = LoggerFactory.getLogger(ConfirmForgotPasswordServlet.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.passwordResetService = (PasswordService)context.getBean(PasswordService.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String id = request.getParameter("id");
        String code = request.getParameter("code");
        String password = request.getParameter("password");
        if (id != null && code != null && password != null) {
            SecurityCodeService.Status status = this.reset(id, code, password);
            if (status == SecurityCodeService.Status.SUCCESS) {
                this.login(response, null);
            } else if (status == SecurityCodeService.Status.EXPIRED) {
                this.login(response, "expired");
            } else if (status == SecurityCodeService.Status.CODE_MISMATCH) {
                request.setAttribute("id", (Object)id);
                request.setAttribute("codemismatch", (Object)true);
                request.getRequestDispatcher("resetpassword").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this.login(response, "error");
            }
        } else {
            this.login(response, "error");
        }
    }

    private void login(HttpServletResponse response, String status) throws IOException {
        String url = "login";
        if (status != null) {
            url = url + "?status=" + status;
        }
        response.sendRedirect(url);
    }

    private SecurityCodeService.Status reset(String id, String code, String password) {
        SecurityCodeService.Status status;
        try {
            status = this.passwordResetService.resetPassword(id, code, password);
        }
        catch (Exception exception) {
            log.error("Failed to reset password for id={}, code={}: {}", new Object[]{id, code, exception.getMessage(), exception});
            status = SecurityCodeService.Status.ERROR;
        }
        return status;
    }
}

