/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomUtils;
import org.openvpms.web.security.login.PasswordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ConfirmForgotPasswordServlet
extends HttpServlet {
    private PasswordService passwordResetService;
    private static final Logger log = LoggerFactory.getLogger(ConfirmForgotPasswordServlet.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.passwordResetService = (PasswordService)context.getBean(PasswordService.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String id = this.sendReset(request);
        if (id == null) {
            try {
                Thread.sleep(RandomUtils.nextInt((int)1000, (int)3001));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            id = UUID.randomUUID().toString();
        }
        request.setAttribute("id", (Object)id);
        request.getRequestDispatcher("resetpassword").forward((ServletRequest)request, (ServletResponse)response);
    }

    private String sendReset(HttpServletRequest request) {
        String result = null;
        String username = request.getParameter("username");
        if (username == null) {
            log.error("No username in request");
        } else {
            result = this.passwordResetService.sendResetCode(username);
        }
        return result;
    }
}

