/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openvpms.web.security.login.MfaAuthenticationToken;
import org.openvpms.web.security.user.LoginUserDetails;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class LoginAuthenticationHandler
implements AuthenticationSuccessHandler {
    private final SimpleUrlAuthenticationSuccessHandler appHandler = new SimpleUrlAuthenticationSuccessHandler("/app");
    private final SimpleUrlAuthenticationSuccessHandler login2Handler;

    public LoginAuthenticationHandler() {
        this.appHandler.setAlwaysUseDefaultTargetUrl(true);
        this.login2Handler = new SimpleUrlAuthenticationSuccessHandler("/selectfactor");
        this.login2Handler.setAlwaysUseDefaultTargetUrl(true);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LoginUserDetails details = (LoginUserDetails)authentication.getPrincipal();
        if (details.isMultiFactorAuthenticationRequired()) {
            this.saveAuthentication((Authentication)new MfaAuthenticationToken(authentication));
            this.login2Handler.onAuthenticationSuccess(request, response, authentication);
        } else {
            authentication = new UsernamePasswordAuthenticationToken((Object)details.getUserDetails(), authentication.getCredentials(), details.getAuthorities());
            this.saveAuthentication(authentication);
            this.appHandler.onAuthenticationSuccess(request, response, authentication);
        }
    }

    private void saveAuthentication(Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

