/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openvpms.component.model.user.User;
import org.openvpms.web.security.login.MfaService;
import org.openvpms.web.security.login.SecurityCodeService;
import org.openvpms.web.security.user.LoginUserDetails;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Login2CodeServlet
extends HttpServlet {
    private MfaService mfaService;

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.mfaService = (MfaService)context.getBean(MfaService.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication.getPrincipal() instanceof LoginUserDetails) {
            LoginUserDetails userDetails = (LoginUserDetails)authentication.getPrincipal();
            org.openvpms.component.business.domain.im.security.User user = userDetails.getUser();
            SecurityCodeService.Factor factor = SecurityCodeService.Factor.fromString(request.getParameter("factor"));
            String code = request.getParameter("code");
            String id = request.getParameter("id");
            SecurityCodeService.Status status = this.mfaService.verifyCode(id, code, factor, (User)user);
            if (status == SecurityCodeService.Status.SUCCESS) {
                this.loggedIn(userDetails, response, authentication);
            } else if (status == SecurityCodeService.Status.CODE_MISMATCH) {
                request.setAttribute("codemismatch", (Object)true);
                request.setAttribute("id", (Object)id);
                request.setAttribute("factor", (Object)factor.toString());
                request.getRequestDispatcher("login2").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this.loginError(request, response);
            }
        } else {
            this.loginError(request, response);
        }
    }

    private void loggedIn(LoginUserDetails userDetails, HttpServletResponse response, Authentication authentication) throws IOException {
        UserDetails details = userDetails.getUserDetails();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)details, authentication.getCredentials(), userDetails.getAuthorities()));
        response.sendRedirect("app");
    }

    private void loginError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        response.sendRedirect("login?status=error");
    }
}

