/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.springframework.web.filter.OncePerRequestFilter;

public class ForceChangePasswordFilter
extends OncePerRequestFilter {
    private final AuthenticationContext context;

    public ForceChangePasswordFilter(AuthenticationContext context) {
        this.context = context;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String path = request.getServletPath();
        boolean redirected = false;
        if ("/app".equals(path)) {
            if (this.userMustChangePassword()) {
                response.sendRedirect("changepassword");
                redirected = true;
            }
        } else if ("/changepassword".equals(path) && !this.userMustChangePassword()) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            response.sendRedirect("login");
            redirected = true;
        }
        if (!redirected) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean userMustChangePassword() {
        User user = (User)this.context.getUser();
        return user != null && user.getChangePassword();
    }
}

