/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import javax.servlet.http.HttpServletRequest;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.web.security.firewall.FirewallService;
import org.openvpms.web.security.firewall.FirewalledUserAuthenticationProvider;
import org.openvpms.web.security.firewall.LoginUserDetailsService;
import org.openvpms.web.security.firewall.NoAccessFromHostException;
import org.openvpms.web.security.user.LoginUserDetailsImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;

public class FirewalledGuiUserAuthenticationProvider
extends FirewalledUserAuthenticationProvider {
    public FirewalledGuiUserAuthenticationProvider(LoginUserDetailsService userService, PasswordEncoder passwordEncoder, FirewallService firewallService) {
        super(userService, passwordEncoder, false, true, firewallService);
    }

    protected User getUser(UserDetails userDetails) {
        User result = userDetails instanceof LoginUserDetailsImpl ? ((LoginUserDetailsImpl)userDetails).getUser() : super.getUser(userDetails);
        return result;
    }

    @Override
    protected void checkAllowedWithMFA(HttpServletRequest request, UserDetails userDetails) {
        if (userDetails instanceof LoginUserDetailsImpl) {
            LoginUserDetailsImpl details = (LoginUserDetailsImpl)userDetails;
            if (details.getEmail() == null && !details.isTOTPConfigured()) {
                throw new NoAccessFromHostException(request.getRemoteAddr());
            }
            details.setMultiFactorAuthenticationRequired();
        } else {
            super.checkAllowedWithMFA(request, userDetails);
        }
    }
}

