/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.archetype.rules.settings.SettingsCache;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.firewall.FirewallConfig;
import org.openvpms.web.security.firewall.FirewallConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class FirewallService {
    private final int cachePeriod;
    private FirewallConfigManager manager;
    private ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(FirewallService.class);

    public FirewallService(int cachePeriod) {
        this.cachePeriod = cachePeriod;
    }

    public void initialise(SettingsCache settings, ArchetypeService service) {
        this.manager = new FirewallConfigManager(settings, this.cachePeriod);
        this.service = service;
    }

    public boolean isAllowed(HttpServletRequest request) {
        return this.isAllowed(request, false);
    }

    public boolean isAllowed(HttpServletRequest request, boolean limitAllowedUser) {
        boolean result = false;
        try {
            FirewallConfig config = this.manager.getConfig();
            FirewallSettings.AccessType type = config.getAccessType();
            result = type == FirewallSettings.AccessType.UNRESTRICTED || type == FirewallSettings.AccessType.ALLOWED_USER && !limitAllowedUser ? true : this.checkAllowed(request, config);
        }
        catch (Exception exception) {
            log.error("Failed to get firewall configuration: {}", (Object)exception.getMessage(), (Object)exception);
        }
        return result;
    }

    public AccessStatus getAccessStatus(HttpServletRequest request, User user, boolean mfaSupported) {
        AccessStatus result = AccessStatus.DENIED;
        try {
            FirewallConfig config = this.manager.getConfig();
            FirewallSettings.AccessType accessType = config.getAccessType();
            if (accessType == FirewallSettings.AccessType.UNRESTRICTED) {
                result = AccessStatus.ALLOWED;
            } else if (!this.checkAllowed(request, config)) {
                if (accessType == FirewallSettings.AccessType.ALLOWED_USER && this.userCanConnectFromAnywhere(user)) {
                    result = mfaSupported && config.isMultifactorAuthenticationEnabled() ? AccessStatus.ALLOWED_WITH_MFA : AccessStatus.ALLOWED;
                }
            } else {
                result = AccessStatus.ALLOWED;
            }
        }
        catch (Exception exception) {
            log.error("Failed to get firewall configuration: {}", (Object)exception.getMessage(), (Object)exception);
        }
        return result;
    }

    public boolean isMultifactorAuthenticationEnabled() {
        FirewallConfig config = this.manager.getConfig();
        return config.isMultifactorAuthenticationEnabled();
    }

    public boolean isMultifactorAuthenticationEnabled(User user) {
        return this.isMultifactorAuthenticationEnabled() && this.userCanConnectFromAnywhere(user);
    }

    private boolean userCanConnectFromAnywhere(User user) {
        IMObjectBean bean = this.service.getBean((IMObject)user);
        return bean.getBoolean("connectFromAnywhere");
    }

    private boolean checkAllowed(HttpServletRequest request, FirewallConfig config) {
        boolean result = false;
        List<IpAddressMatcher> allowed = config.getAllowedAddresses();
        for (IpAddressMatcher matcher : allowed) {
            if (!matcher.matches(request)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static enum AccessStatus {
        ALLOWED,
        ALLOWED_WITH_MFA,
        DENIED;

    }
}

