/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import java.util.List;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.model.entity.Entity;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

class FirewallConfig {
    private final List<IpAddressMatcher> allowed;
    private final FirewallSettings.AccessType accessType;
    private final boolean mfaEnabled;
    private final String version;

    public FirewallConfig(FirewallSettings settings, List<IpAddressMatcher> allowed) {
        this.allowed = allowed;
        this.accessType = settings.getAccessType();
        this.mfaEnabled = settings.isMultifactorAuthenticationEnabled();
        this.version = this.getVersion(settings.getSettings());
    }

    public FirewallSettings.AccessType getAccessType() {
        return this.accessType;
    }

    public boolean isMultifactorAuthenticationEnabled() {
        return this.mfaEnabled;
    }

    public List<IpAddressMatcher> getAllowedAddresses() {
        return this.allowed;
    }

    public boolean needsUpdate(Entity config) {
        return !this.version.equals(this.getVersion(config));
    }

    private String getVersion(Entity config) {
        return config.getId() + ":" + config.getVersion();
    }
}

