/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.login.SecurityCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;

public abstract class SecurityCodeService {
    protected static final int MAX_ATTEMPTS = 3;
    private final Map<String, SecurityCode> codes = Collections.synchronizedMap(new PassiveExpiringMap(10L, TimeUnit.MINUTES));
    private final ArchetypeService service;
    private final PracticeService practiceService;
    private final Contacts contacts;
    private volatile boolean missingEmailLogged;
    private static final Logger log = LoggerFactory.getLogger(SecurityCodeService.class);

    public SecurityCodeService(ArchetypeService service, PracticeService practiceService) {
        this.service = service;
        this.practiceService = practiceService;
        this.contacts = new Contacts(service);
    }

    protected String sendCode(User user) {
        String result = null;
        String to = this.getToAddress(user);
        if (to != null) {
            result = this.sendCode(user, to);
        }
        return result;
    }

    protected String sendCode(User user, String to) {
        SecurityCode code;
        String result = null;
        String from = this.getFromAddress();
        if (from != null && this.sendCode(user, (code = this.generateCode(user, Factor.EMAIL)).getCode(), from, to)) {
            result = code.getId();
        }
        return result;
    }

    protected abstract boolean sendCode(User var1, String var2, String var3, String var4);

    protected Status applyCode(String id, String code, Function<Long, Status> operation) {
        SecurityCode securityCode = this.getCode(id);
        Status result = this.verifyCode(id, code, Factor.EMAIL, securityCode);
        if (result == Status.SUCCESS) {
            result = operation.apply(securityCode.getUserId());
        }
        return result;
    }

    protected String getFromAddress() {
        String from = this.getEmail(this.practiceService.getPractice());
        if (from == null) {
            if (!this.missingEmailLogged) {
                log.error("Cannot send security mails as the practice has no email address configured");
                this.missingEmailLogged = true;
            }
        } else {
            this.missingEmailLogged = false;
        }
        return from;
    }

    protected String getToAddress(User user) {
        String to = this.getEmail((Party)user);
        if (to == null) {
            log.error("Cannot send security mails to {} as the user has no email address configured", (Object)user.getUsername());
        }
        return to;
    }

    protected SecurityCode getCode(String id) {
        return this.codes.get(id);
    }

    protected SecurityCode generateCode(User user, Factor factor) {
        SecurityCode code = new SecurityCode(user, factor);
        this.codes.put(code.getId(), code);
        return code;
    }

    protected Status verifyCode(String id, String code, Factor factor, SecurityCode securityCode) {
        Status result;
        if (securityCode == null || factor != securityCode.getFactor()) {
            result = Status.EXPIRED;
        } else if (!Objects.equals(securityCode.getCode(), code)) {
            result = this.codeMismatch(securityCode);
        } else {
            result = Status.SUCCESS;
            this.removeCode(id);
        }
        return result;
    }

    protected Status codeMismatch(SecurityCode securityCode) {
        Status result;
        if (securityCode.incAttempts() < 3) {
            result = Status.CODE_MISMATCH;
        } else {
            result = Status.EXPIRED;
            this.removeCode(securityCode.getId());
        }
        return result;
    }

    protected ArchetypeService getArchetypeService() {
        return this.service;
    }

    protected PracticeService getPracticeService() {
        return this.practiceService;
    }

    protected String getEmail(Party party) {
        return party != null ? this.contacts.getEmail(party) : null;
    }

    protected void save(User user) {
        ArchetypeService unrestricted = null;
        if (this.service instanceof Advised) {
            try {
                unrestricted = (ArchetypeService)((Advised)this.service).getTargetSource().getTarget();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (unrestricted == null) {
            unrestricted = this.service;
        }
        unrestricted.save((IMObject)user);
    }

    private void removeCode(String id) {
        this.codes.remove(id);
    }

    public static enum Status {
        EXPIRED,
        CODE_MISMATCH,
        DATA_MISMATCH,
        ERROR,
        SUCCESS;

    }

    public static enum Factor {
        EMAIL,
        TOTP;


        public static Factor fromString(String value) {
            return value != null ? (Factor)Arrays.stream(Factor.values()).filter(factor -> factor.name().equals(value)).findFirst().orElse(null) : null;
        }
    }
}

