/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openvpms.component.model.user.User;
import org.openvpms.web.security.login.MfaService;
import org.openvpms.web.security.login.SecurityCodeService;
import org.openvpms.web.security.user.LoginUserDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginFactorSelectedServlet
extends HttpServlet {
    private MfaService service;

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.service = (MfaService)context.getBean(MfaService.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication.getPrincipal() instanceof LoginUserDetails) {
            LoginUserDetails userDetails = (LoginUserDetails)authentication.getPrincipal();
            SecurityCodeService.Factor factor = SecurityCodeService.Factor.fromString(request.getParameter("factor"));
            if (SecurityCodeService.Factor.EMAIL.equals((Object)factor)) {
                String id = this.sendCode(userDetails);
                if (id != null) {
                    this.forwardToLogin2(factor, id, request, response);
                } else {
                    this.loginError(request, response);
                }
            } else if (SecurityCodeService.Factor.TOTP.equals((Object)factor)) {
                String id = this.service.generateTOTPCode((User)userDetails.getUserDetails());
                this.forwardToLogin2(factor, id, request, response);
            } else {
                this.loginError(request, response);
            }
        } else {
            this.loginError(request, response);
        }
    }

    private String sendCode(LoginUserDetails userDetails) {
        String id = null;
        String email = userDetails.getEmail();
        if (email != null) {
            id = this.service.sendCode((User)userDetails.getUserDetails(), email);
        }
        return id;
    }

    private void forwardToLogin2(SecurityCodeService.Factor factor, String id, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("factor", (Object)factor.toString());
        request.setAttribute("id", (Object)id);
        request.getRequestDispatcher("login2").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void loginError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        response.sendRedirect("login?status=error");
    }
}

