/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.security.UserService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.user.LoginUserDetails;
import org.openvpms.web.security.user.LoginUserDetailsImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LoginUserDetailsService
implements UserDetailsService {
    private final UserService userService;
    private ArchetypeService archetypeService;
    private Contacts contacts;

    public LoginUserDetailsService(UserService userService) {
        this.userService = userService;
    }

    public void setArchetypeService(ArchetypeService archetypeService) {
        this.archetypeService = archetypeService;
        this.contacts = new Contacts(archetypeService);
    }

    public LoginUserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails details = this.userService.loadUserByUsername(username);
        User user = (User)details;
        String email = this.contacts.getEmail((Party)user);
        IMObjectBean bean = this.archetypeService.getBean((IMObject)user);
        String secret = bean.getString("totpSecret");
        return new LoginUserDetailsImpl(user, email, secret != null);
    }
}

