/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.archetype.rules.settings.SettingsCache;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.security.firewall.FirewallConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

class FirewallConfigManager {
    private final SettingsCache settings;
    private final long cachePeriod;
    private volatile FirewallConfig config;
    private long updated = -1L;
    private static final Logger log = LoggerFactory.getLogger(FirewallConfigManager.class);

    public FirewallConfigManager(SettingsCache settings, int cachePeriod) {
        this.settings = settings;
        this.cachePeriod = TimeUnit.MINUTES.toMillis(cachePeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirewallConfig getConfig() {
        IMObjectBean bean = this.settings.getGroup("entity.globalSettingsFirewall", this.useCachedSettings());
        if (this.needsUpdate(bean)) {
            FirewallConfigManager firewallConfigManager = this;
            synchronized (firewallConfigManager) {
                if (this.needsUpdate(bean)) {
                    this.loadConfig(bean);
                }
            }
        }
        return this.config;
    }

    protected boolean useCachedSettings() {
        long time = this.updated;
        return time == -1L || System.currentTimeMillis() - time < this.cachePeriod;
    }

    protected boolean needsUpdate(IMObjectBean bean) {
        FirewallConfig stored = this.config;
        return stored == null || stored.needsUpdate((Entity)bean.getObject(Entity.class));
    }

    private void loadConfig(IMObjectBean bean) {
        boolean first = this.config == null;
        FirewallSettings settings = new FirewallSettings(bean);
        List<String> active = this.getActiveAddresses(settings);
        List<IpAddressMatcher> matchers = this.getIpAddressMatchers(active);
        this.config = new FirewallConfig(settings, matchers);
        this.updated = System.currentTimeMillis();
        if (!first) {
            log.info("Firewall configuration updated");
        }
        if (log.isInfoEnabled()) {
            log.info("Access={}, allowed={}", (Object)settings.getAccessType(), (Object)StringUtils.join(active, (String)","));
        }
    }

    private List<String> getActiveAddresses(FirewallSettings settings) {
        return settings.getAllowedAddresses().stream().filter(FirewallEntry::isActive).map(FirewallEntry::getAddress).collect(Collectors.toList());
    }

    private List<IpAddressMatcher> getIpAddressMatchers(List<String> addresses) {
        return addresses.stream().map(IpAddressMatcher::new).collect(Collectors.toList());
    }
}

