/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.openvpms.component.model.user.User;
import org.openvpms.web.security.login.SecurityCodeService;

class SecurityCode {
    private final String id = UUID.randomUUID().toString();
    private final String code = String.format("%06d", random.nextInt(1000000));
    private final long userId;
    private final SecurityCodeService.Factor factor;
    private int attempts;
    private static final Random random = new SecureRandom();

    public SecurityCode(User user, SecurityCodeService.Factor factor) {
        this(user.getId(), factor);
    }

    public SecurityCode(long userId, SecurityCodeService.Factor factor) {
        this.userId = userId;
        this.factor = factor;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public long getUserId() {
        return this.userId;
    }

    public SecurityCodeService.Factor getFactor() {
        return this.factor;
    }

    public synchronized int incAttempts() {
        return ++this.attempts;
    }
}

