/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.user.PasswordValidator;
import org.openvpms.component.business.dao.im.security.IUserDAO;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.login.PasswordMailer;
import org.openvpms.web.security.login.SecurityCodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordService
extends SecurityCodeService {
    private final ArchetypeService service;
    private final IUserDAO users;
    private final PasswordEncoder encoder;
    private final PasswordValidator validator;
    private final PasswordMailer mailer;
    private static final Logger log = LoggerFactory.getLogger(PasswordService.class);

    public PasswordService(ArchetypeService service, IUserDAO users, PasswordEncoder encoder, PasswordValidator validator, PracticeService practiceService, PasswordMailer mailer) {
        super(service, practiceService);
        this.service = service;
        this.users = users;
        this.encoder = encoder;
        this.validator = validator;
        this.mailer = mailer;
    }

    public String sendResetCode(String username) {
        String result = null;
        User user = this.getUser(username);
        if (user == null) {
            log.error("Cannot send reset code. No active user with username {}", (Object)username);
        } else {
            result = this.sendCode(user);
        }
        return result;
    }

    public SecurityCodeService.Status resetPassword(String id, String code, String password) {
        return this.applyCode(id, code, userId -> {
            SecurityCodeService.Status result;
            if (!this.validate(password)) {
                result = SecurityCodeService.Status.ERROR;
            } else {
                User user = (User)this.service.get("security.user", userId.longValue(), true);
                if (user != null) {
                    this.setPassword(user, password);
                    this.sendNotification(user);
                    result = SecurityCodeService.Status.SUCCESS;
                } else {
                    log.warn("Cannot reset password for user id={}. No active user exists", userId);
                    result = SecurityCodeService.Status.ERROR;
                }
            }
            return result;
        });
    }

    public SecurityCodeService.Status changePassword(User user, String oldPassword, String newPassword) {
        SecurityCodeService.Status result;
        String existing = ((org.openvpms.component.business.domain.im.security.User)user).getPassword();
        if (this.encoder.matches((CharSequence)oldPassword, existing)) {
            if (!oldPassword.equals(newPassword) && this.validate(newPassword)) {
                this.setPassword(user, newPassword);
                this.sendNotification(user);
                result = SecurityCodeService.Status.SUCCESS;
            } else {
                result = SecurityCodeService.Status.ERROR;
            }
        } else {
            result = SecurityCodeService.Status.DATA_MISMATCH;
        }
        return result;
    }

    @Override
    protected boolean sendCode(User user, String code, String from, String to) {
        boolean result = false;
        try {
            this.mailer.sendResetCode(from, to, code);
            result = true;
        }
        catch (Exception exception) {
            log.error("Failed to send reset code to {}: {}", (Object)to, (Object)exception.getMessage());
        }
        return result;
    }

    private void setPassword(User user, String password) {
        IMObjectBean bean = this.service.getBean((IMObject)user);
        bean.setValue("password", (Object)this.encoder.encode((CharSequence)password));
        bean.setValue("changePassword", (Object)false);
        this.save(user);
        log.warn("Password changed for user id={}, username={}", (Object)user.getId(), (Object)user.getUsername());
    }

    private User getUser(String username) {
        org.openvpms.component.business.domain.im.security.User user = this.users.getUser(username);
        return user != null && user.isActive() ? user : null;
    }

    private void sendNotification(User user) {
        String from = this.getFromAddress();
        String to = this.getToAddress(user);
        if (from != null && to != null) {
            try {
                this.mailer.sendPasswordChanged(from, to);
            }
            catch (Exception exception) {
                log.error("Failed to send notification to {}: {}", (Object)to, (Object)exception.getMessage());
            }
        }
    }

    private boolean validate(String password) {
        List errors = this.validator.validate(password);
        if (!errors.isEmpty()) {
            log.error("Password doesn't match policy: {}", (Object)StringUtils.join((Iterable)errors, (String)","));
        }
        return errors.isEmpty();
    }
}

