/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.net.URLEncoder;
import org.jboss.aerogear.security.otp.Totp;
import org.jboss.aerogear.security.otp.api.Base32;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.login.MfaMailer;
import org.openvpms.web.security.login.SecurityCode;
import org.openvpms.web.security.login.SecurityCodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MfaService
extends SecurityCodeService {
    private final MfaMailer mailer;
    private final PasswordEncryptor encryptor;
    private static final String APP_NAME = "OpenVPMS";
    private static final Logger log = LoggerFactory.getLogger(MfaService.class);
    private static final String TOTP_SECRET = "totpSecret";

    public MfaService(ArchetypeService service, PracticeService practiceService, MfaMailer mailer, PasswordEncryptor encryptor) {
        super(service, practiceService);
        this.mailer = mailer;
        this.encryptor = encryptor;
    }

    @Override
    public String sendCode(User user, String to) {
        return super.sendCode(user, to);
    }

    public String generateTOTPCode(User user) {
        SecurityCode securityCode = this.generateCode(user, SecurityCodeService.Factor.TOTP);
        return securityCode.getId();
    }

    public SecurityCodeService.Status verifyCode(String id, String code, SecurityCodeService.Factor factor, User user) {
        SecurityCode securityCode = this.getCode(id);
        SecurityCodeService.Status result = securityCode != null && factor != null ? (securityCode.getFactor() == SecurityCodeService.Factor.TOTP ? this.verifyTOTP(code, user, securityCode) : this.verifyCode(id, code, factor, securityCode)) : SecurityCodeService.Status.EXPIRED;
        return result;
    }

    public boolean hasTOTP(User user) {
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)user);
        return bean.getString(TOTP_SECRET) != null;
    }

    public void configureTOTP(User user) {
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)user);
        String encrypted = this.encryptor.encrypt(Base32.random());
        bean.setValue(TOTP_SECRET, (Object)encrypted);
        this.save(user);
    }

    public void removeTOTP(User user) {
        if (this.hasTOTP(user)) {
            IMObjectBean bean = this.getArchetypeService().getBean((IMObject)user);
            bean.setValue(TOTP_SECRET, null);
            this.save(user);
        }
    }

    public String getQRCodeURL(User user) {
        String url = null;
        String secret = this.getTOTPSecret(user);
        if (secret != null) {
            Party practice;
            String account = user.getName();
            if (account == null) {
                account = user.getUsername();
            }
            String issuer = (practice = this.getPracticeService().getPractice()) != null ? practice.getName() : APP_NAME;
            issuer = issuer.replaceAll("[:&]", " ");
            try {
                url = String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, account, secret, issuer);
                URLEncoder.encode(url, "utf8");
            }
            catch (Exception exception) {
                log.error("Failed to encode QRCode url for user {}: {}", new Object[]{user.getUsername(), exception.getMessage(), exception});
            }
        }
        return url;
    }

    @Override
    protected boolean sendCode(User user, String code, String from, String to) {
        boolean result = false;
        try {
            this.mailer.sendCode(from, to, code);
            result = true;
        }
        catch (Exception exception) {
            log.error("Failed to send code to user={}, email={}: {}", new Object[]{user.getUsername(), to, exception.getMessage(), exception});
        }
        return result;
    }

    private SecurityCodeService.Status verifyTOTP(String code, User user, SecurityCode securityCode) {
        Totp totp;
        String secret = this.getTOTPSecret(user);
        SecurityCodeService.Status result = secret != null ? (!(totp = new Totp(secret)).verify(code) ? this.codeMismatch(securityCode) : SecurityCodeService.Status.SUCCESS) : SecurityCodeService.Status.ERROR;
        return result;
    }

    private String getTOTPSecret(User user) {
        String result = null;
        try {
            String encrypted = this.getArchetypeService().getBean((IMObject)user).getString(TOTP_SECRET);
            result = encrypted != null ? this.encryptor.decrypt(encrypted) : null;
        }
        catch (Exception exception) {
            log.error("Failed to decrypt TOTP secret for user {}: {}", new Object[]{user.getUsername(), exception.getMessage(), exception});
        }
        return result;
    }
}

