/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.math.NumberUtils;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.model.user.User;
import org.openvpms.web.security.login.PasswordService;
import org.openvpms.web.security.login.SecurityCodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ConfirmChangePasswordServlet
extends HttpServlet {
    private AuthenticationContext authenticationContext;
    private PasswordService passwordResetService;
    private static final String CHANGE_PASSWORD_ATTEMPTS = "_change_password_attempts";
    private static final Logger log = LoggerFactory.getLogger(ConfirmChangePasswordServlet.class);
    private static final int MAX_ATTEMPTS = 5;

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.passwordResetService = (PasswordService)context.getBean(PasswordService.class);
        this.authenticationContext = (AuthenticationContext)context.getBean(AuthenticationContext.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        String oldPassword = request.getParameter("oldPassword");
        String newPassword = request.getParameter("newPassword");
        org.openvpms.component.business.domain.im.security.User user = (org.openvpms.component.business.domain.im.security.User)this.authenticationContext.getUser();
        int attempts = this.getAttempts(session);
        if (session != null && user != null && oldPassword != null && newPassword != null && attempts < 5) {
            SecurityCodeService.Status status = this.changePassword(user, oldPassword, newPassword);
            if (status == SecurityCodeService.Status.SUCCESS) {
                this.login(response, session, null);
            } else if (status == SecurityCodeService.Status.DATA_MISMATCH) {
                request.setAttribute("passwordmismatch", (Object)true);
                session.setAttribute(CHANGE_PASSWORD_ATTEMPTS, (Object)(attempts + 1));
                request.getRequestDispatcher("changepassword").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this.login(response, session, "error");
            }
        } else {
            this.login(response, session, "error");
        }
    }

    private void login(HttpServletResponse response, HttpSession session, String status) throws IOException {
        if (session != null) {
            session.invalidate();
        }
        String path = "login";
        if (status != null) {
            path = path + "?status=" + status;
        }
        response.sendRedirect(path);
    }

    private SecurityCodeService.Status changePassword(org.openvpms.component.business.domain.im.security.User user, String oldPassword, String newPassword) {
        SecurityCodeService.Status status;
        try {
            status = this.passwordResetService.changePassword((User)user, oldPassword, newPassword);
        }
        catch (Exception exception) {
            log.error("Failed to change password for user {}: {}", new Object[]{user.getUsername(), exception.getMessage(), exception});
            status = SecurityCodeService.Status.ERROR;
        }
        return status;
    }

    private int getAttempts(HttpSession session) {
        Object attribute;
        int attempts = 0;
        if (session != null && (attribute = session.getAttribute(CHANGE_PASSWORD_ATTEMPTS)) != null) {
            attempts = NumberUtils.toInt((String)attribute.toString(), (int)0);
        }
        return attempts;
    }
}

