/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.firewall;

import javax.servlet.http.HttpServletRequest;
import org.openvpms.component.business.service.security.UserAuthenticationProvider;
import org.openvpms.component.model.user.User;
import org.openvpms.web.security.firewall.FirewallService;
import org.openvpms.web.security.firewall.NoAccessFromHostException;
import org.openvpms.web.security.login.MfaAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class FirewalledUserAuthenticationProvider
extends UserAuthenticationProvider {
    private final FirewallService firewallService;
    private final boolean enableMultifactorAuthentication;

    public FirewalledUserAuthenticationProvider(UserDetailsService userService, PasswordEncoder passwordEncoder, boolean expireOnChangePassword, boolean enableMultifactorAuthentication, FirewallService firewallService) {
        super(userService, passwordEncoder, expireOnChangePassword);
        this.firewallService = firewallService;
        this.enableMultifactorAuthentication = enableMultifactorAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return super.supports(authentication) && !MfaAuthenticationToken.class.isAssignableFrom(authentication);
    }

    protected void checkAuthentication(UserDetails userDetails) {
        this.checkAllowed(userDetails);
        super.checkAuthentication(userDetails);
    }

    protected void checkAllowedWithMFA(HttpServletRequest request, UserDetails userDetails) {
        throw new NoAccessFromHostException(request.getRemoteAddr());
    }

    private void checkAllowed(UserDetails userDetails) {
        org.openvpms.component.business.domain.im.security.User user;
        HttpServletRequest request;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            request = ((ServletRequestAttributes)requestAttributes).getRequest();
            user = this.getUser(userDetails);
            if (user == null) {
                throw new NoAccessFromHostException(request.getRemoteAddr());
            }
        } else {
            throw new IllegalStateException("Not called from within a web request");
        }
        this.checkAllowed(request, user, userDetails);
    }

    private void checkAllowed(HttpServletRequest request, org.openvpms.component.business.domain.im.security.User user, UserDetails userDetails) {
        FirewallService.AccessStatus status = this.firewallService.getAccessStatus(request, (User)user, this.enableMultifactorAuthentication);
        if (status == FirewallService.AccessStatus.DENIED) {
            throw new NoAccessFromHostException(request.getRemoteAddr());
        }
        if (status == FirewallService.AccessStatus.ALLOWED_WITH_MFA) {
            this.checkAllowedWithMFA(request, userDetails);
        }
    }
}

