/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.resource.i18n.format;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.resource.i18n.Messages;

public class DateFormatter {
    private static final String DATE_EDIT_PATTERN;
    private static final String DATE_VIEW_PATTERN;
    private static final String FULL_DATE_PATTERN;
    private static final String DAY_MONTH_DATE_PATTERN;
    private static final String DAY_PATTERN;
    private static final String TIME_EDIT_PATTERN;
    private static final String TIME_VIEW_PATTERN;
    private static final String FULL_TIME_PATTERN;
    private static final String DATE_TIME_VIEW_PATTERN;
    private static final Date WIDE_DATE;

    public static String formatDate(Date date, boolean edit) {
        return DateFormatter.getDateFormat(edit).format(date);
    }

    public static String formatDate(OffsetDateTime date, boolean edit) {
        return DateFormatter.formatDate(DateRules.toDate((OffsetDateTime)date), edit);
    }

    public static DateFormat getDateFormat(boolean edit) {
        String pattern;
        Locale locale = Messages.getLocale();
        String string = pattern = edit ? DATE_EDIT_PATTERN : DATE_VIEW_PATTERN;
        DateFormat format = pattern == null ? (edit ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(2, locale)) : new SimpleDateFormat(pattern, locale);
        return format;
    }

    public static DateFormat getFullDateFormat() {
        Locale locale = Messages.getLocale();
        if (FULL_DATE_PATTERN != null) {
            return new SimpleDateFormat(FULL_DATE_PATTERN, locale);
        }
        return DateFormat.getDateInstance(0, locale);
    }

    public static DateFormat getFullTimeFormat() {
        Locale locale = Messages.getLocale();
        if (FULL_TIME_PATTERN != null) {
            return new SimpleDateFormat(FULL_TIME_PATTERN, locale);
        }
        return DateFormat.getTimeInstance(0);
    }

    public static DateFormat getDayMonthDateFormat() {
        Locale locale = Messages.getLocale();
        if (DAY_MONTH_DATE_PATTERN != null) {
            return new SimpleDateFormat(DAY_MONTH_DATE_PATTERN, locale);
        }
        return DateFormatter.getFullDateFormat();
    }

    public static DateFormat getDayFormat() {
        Locale locale = Messages.getLocale();
        return DAY_PATTERN != null ? new SimpleDateFormat(DAY_PATTERN, locale) : new SimpleDateFormat("EEEE", locale);
    }

    public static String formatTime(Date time, boolean edit) {
        return DateFormatter.getTimeFormat(edit).format(time);
    }

    public static String formatTime(OffsetDateTime time, boolean edit) {
        return DateFormatter.formatTime(DateRules.toDate((OffsetDateTime)time), edit);
    }

    public static DateFormat getTimeFormat(boolean edit) {
        String pattern;
        Locale locale = Messages.getLocale();
        String string = pattern = edit ? TIME_EDIT_PATTERN : TIME_VIEW_PATTERN;
        DateFormat format = pattern == null ? (edit ? DateFormat.getTimeInstance(3, locale) : DateFormat.getTimeInstance(2, locale)) : new SimpleDateFormat(pattern, locale);
        return format;
    }

    public static DateFormat getTimeFormat(int style) {
        return DateFormat.getTimeInstance(style, Messages.getLocale());
    }

    public static DateFormat getDateTimeFormat(boolean edit) {
        Locale locale = Messages.getLocale();
        DateFormat format = edit ? DateFormat.getDateTimeInstance(3, 3, locale) : (DATE_TIME_VIEW_PATTERN != null ? new SimpleDateFormat(DATE_TIME_VIEW_PATTERN, locale) : DateFormat.getDateTimeInstance(2, 3, locale));
        return format;
    }

    public static String formatDateTime(Date dateTime) {
        return DateFormatter.formatDateTime(dateTime, false);
    }

    public static String formatDateTime(Date dateTime, boolean edit) {
        return DateFormatter.getDateTimeFormat(edit).format(dateTime);
    }

    public static String formatDateTimeAbbrev(Date dateTime) {
        return DateFormatter.formatDateTimeAbbrev(dateTime, DateRules.getToday());
    }

    public static String formatDateTimeAbbrev(OffsetDateTime dateTime) {
        return DateFormatter.formatDateTimeAbbrev(new Date(dateTime.toInstant().toEpochMilli()));
    }

    public static String formatDateTimeAbbrev(Date dateTime, Date date) {
        String result = DateRules.dateEquals((Date)dateTime, (Date)date) ? DateFormatter.formatTime(dateTime, false) : DateFormatter.formatDateTime(dateTime);
        return result;
    }

    public static int getLength(DateFormat format) {
        return format.format(WIDE_DATE).length();
    }

    public static String formatTimeDiff(Date from, Date to) {
        if (from == null || to == null) {
            return null;
        }
        long diff = to.getTime() - from.getTime();
        if (diff < 0L) {
            diff = 0L;
        }
        return DateFormatter.formatTime(diff);
    }

    public static String formatTime(long time) {
        long hours = time / 3600000L;
        long mins = time % 3600000L / 60000L;
        return Messages.format("time.format.abs", hours, mins);
    }

    public static Date parseTime(String time) throws ParseException {
        return DateFormatter.parseTime(time, false);
    }

    public static Date parseTime(String time, boolean allow24) throws ParseException {
        Date result;
        DateFormat format = DateFormatter.getTimeFormat(true);
        try {
            result = format.parse(time);
        }
        catch (ParseException exception) {
            if (time.length() <= 2) {
                result = DateFormatter.parseHours(time, allow24);
            }
            if (time.length() <= 4) {
                result = DateFormatter.parseHoursMins(time, allow24);
            }
            throw exception;
        }
        return result;
    }

    public static String formatUnits(DateUnits units, boolean plural) {
        String result = Messages.formatNull("dateunits." + units, plural ? 0 : 1);
        return result != null ? result : units.toString();
    }

    public static String formatInterval(int interval, DateUnits units) {
        return Messages.format("dateunits.interval", interval, DateFormatter.formatUnits(units, interval != 1));
    }

    private static Date parseHours(String value, boolean allow24) {
        int hours = DateFormatter.getHours(value, allow24);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hours);
        return calendar.getTime();
    }

    private static int getHours(String value, boolean allow24) {
        int hours = Integer.parseInt(value);
        if (hours < 0 || !allow24 && hours > 23 || allow24 && hours > 24) {
            throw new IllegalArgumentException(value);
        }
        return hours;
    }

    private static Date parseHoursMins(String value, boolean allow24) {
        String hourPart = value.length() == 3 ? value.substring(0, 1) : value.substring(0, 2);
        int hours = DateFormatter.getHours(hourPart, allow24);
        String minPart = value.substring(hourPart.length());
        int mins = Integer.parseInt(minPart);
        if (mins < 0 || mins > 59) {
            throw new IllegalArgumentException("Minutes exceed range 0..59: " + minPart);
        }
        if (hours == 24 && mins > 0) {
            throw new IllegalArgumentException("Maximum time (24:00) exceeded");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(11, hours);
        calendar.set(12, mins);
        return calendar.getTime();
    }

    static {
        String dateEdit = Messages.get("date.format.edit", true);
        DATE_EDIT_PATTERN = !StringUtils.isEmpty((CharSequence)dateEdit) ? dateEdit : null;
        String dateView = Messages.get("date.format.view", true);
        DATE_VIEW_PATTERN = !StringUtils.isEmpty((CharSequence)dateView) ? dateView : null;
        String fullDate = Messages.get("date.format.full", true);
        FULL_DATE_PATTERN = !StringUtils.isEmpty((CharSequence)fullDate) ? fullDate : null;
        String day = Messages.get("date.format.day", true);
        DAY_PATTERN = !StringUtils.isEmpty((CharSequence)day) ? day : null;
        String dayMonth = Messages.get("date.format.dayMonth", true);
        DAY_MONTH_DATE_PATTERN = !StringUtils.isEmpty((CharSequence)dayMonth) ? dayMonth : null;
        String timeEdit = Messages.get("time.format.edit", true);
        TIME_EDIT_PATTERN = !StringUtils.isEmpty((CharSequence)timeEdit) ? timeEdit : null;
        String timeView = Messages.get("time.format.view", true);
        TIME_VIEW_PATTERN = !StringUtils.isEmpty((CharSequence)timeView) ? timeView : null;
        String fullTime = Messages.get("time.format.full", true);
        FULL_TIME_PATTERN = !StringUtils.isEmpty((CharSequence)fullTime) ? fullTime : null;
        String dateTimeView = Messages.get("datetime.format.view", true);
        DATE_TIME_VIEW_PATTERN = !StringUtils.isEmpty((CharSequence)dateTimeView) ? dateTimeView : null;
        GregorianCalendar calendar = new GregorianCalendar(2006, 11, 30, 12, 59, 59);
        WIDE_DATE = calendar.getTime();
    }
}

