/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.resource.i18n.message;

import java.util.Locale;
import org.openvpms.web.resource.i18n.message.MessageResource;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ResourceBundleMessageSource;

public class DefaultMessageResource
implements MessageResource {
    private final MessageSource source;
    private final Locale locale;

    public DefaultMessageResource(String[] bundles) {
        this(DefaultMessageResource.createMessageSource(bundles));
    }

    public DefaultMessageResource(MessageSource source) {
        this(source, Locale.getDefault());
    }

    public DefaultMessageResource(MessageSource source, Locale locale) {
        this.source = source;
        this.locale = locale;
    }

    @Override
    public String get(String key) {
        return this.get(key, this.locale);
    }

    @Override
    public String get(String key, Locale locale) {
        return this.get(key, false, locale);
    }

    @Override
    public String get(String key, boolean allowNull) {
        return this.get(key, allowNull, this.locale);
    }

    @Override
    public String get(String key, boolean allowNull, Locale locale) {
        return this.getMessage(key, new Object[0], allowNull, locale);
    }

    @Override
    public String format(String key, Object ... arguments) {
        return this.format(key, this.locale, arguments);
    }

    @Override
    public String format(String key, Locale locale, Object ... arguments) {
        return this.getMessage(key, arguments, false, locale);
    }

    @Override
    public String formatNull(String key, Object ... arguments) {
        return this.formatNull(key, this.locale, arguments);
    }

    @Override
    public String formatNull(String key, Locale locale, Object ... arguments) {
        return this.getMessage(key, arguments, true, locale);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    protected MessageSource getSource() {
        return this.source;
    }

    protected String getMessage(String key, Object[] arguments, boolean allowNull, Locale locale) {
        String result;
        try {
            result = allowNull ? this.source.getMessage(key, arguments, null, locale) : this.source.getMessage(key, arguments, locale);
        }
        catch (NoSuchMessageException exception) {
            result = '!' + key + '!';
        }
        return result;
    }

    protected static MessageSource createMessageSource(String[] bundles) {
        ResourceBundleMessageSource source = new ResourceBundleMessageSource();
        source.setBasenames(bundles);
        return source;
    }
}

