/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.resource.i18n.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFormatter {
    public static final String DECIMAL_EDIT = "decimal.format.edit";
    public static final String DECIMAL_VIEW = "decimal.format.view";
    public static final String INTEGER_EDIT = "integer.format.edit";
    public static final String INTEGER_VIEW = "integer.format.view";
    public static final String ID_FORMAT = "id.format";
    public static final Logger log = LoggerFactory.getLogger(NumberFormatter.class);

    public static String format(Number value) {
        NumberFormat format = value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte ? NumberFormatter.getFormat(INTEGER_VIEW) : NumberFormatter.getFormat(DECIMAL_VIEW);
        return NumberFormatter.format(value, format);
    }

    public static String format(Number value, NumberFormat format) {
        String result;
        if (value != null) {
            try {
                result = format.format(value);
            }
            catch (IllegalArgumentException exception) {
                result = value.toString();
            }
        } else {
            result = null;
        }
        return result;
    }

    public static String formatCurrency(Number amount) {
        String result;
        if (amount != null) {
            try {
                result = NumberFormatter.getCurrencyFormat().format(amount);
            }
            catch (IllegalArgumentException exception) {
                result = amount.toString();
            }
        } else {
            result = null;
        }
        return result;
    }

    public static NumberFormat getFormat(String key) {
        Locale locale = Messages.getLocale();
        String pattern = Messages.get(key);
        try {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(pattern, symbols);
        }
        catch (Exception exception) {
            log.error("Failed to create format for key=" + key + ", locale=" + locale + ", pattern=" + pattern, (Throwable)exception);
            return NumberFormat.getInstance();
        }
    }

    public static NumberFormat getCurrencyFormat() {
        return NumberFormat.getCurrencyInstance();
    }

    public static String getSize(long size) {
        String result = size / 0x280000000L > 0L ? NumberFormatter.getSize(size, 0x40000000L, "size.GB") : (size / 0x100000L > 0L ? NumberFormatter.getSize(size, 0x100000L, "size.MB") : (size / 1024L > 0L ? NumberFormatter.getSize(size, 1024L, "size.KB") : Messages.format("size.bytes", size)));
        return result;
    }

    private static String getSize(long size, long divisor, String key) {
        BigDecimal result = new BigDecimal(size).divide(BigDecimal.valueOf(divisor), 2);
        return Messages.format(key, result);
    }
}

