/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.reminder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderProcessor;
import org.openvpms.archetype.rules.patient.reminder.ReminderQueueIterator;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.scheduler.SingletonJob;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.retry.AbstractRetryable;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.resource.i18n.Messages;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class PatientReminderQueueJob
implements InterruptableJob,
SingletonJob {
    protected static final String JOB_SHORT_NAME = "entity.jobPatientReminderQueue";
    private final Entity configuration;
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final PatientRules rules;
    private final PlatformTransactionManager transactionManager;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    private int queued;
    private int cancelled;
    private int skipped;
    private int errors;
    private static final Log log = LogFactory.getLog(PatientReminderQueueJob.class);

    public PatientReminderQueueJob(Entity configuration, IArchetypeRuleService service, PracticeService practiceService, PatientRules rules, PlatformTransactionManager transactionManager) {
        this.configuration = configuration;
        this.service = service;
        this.practiceService = practiceService;
        this.transactionManager = transactionManager;
        this.rules = rules;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) {
        long begin = System.currentTimeMillis();
        try {
            this.queue();
            this.complete(null, begin);
        }
        catch (Throwable exception) {
            log.error((Object)exception, exception);
            this.complete(exception, begin);
        }
    }

    protected void queue() {
        Party practice = this.practiceService.getPractice();
        if (practice == null) {
            throw new IllegalStateException("The practice has not been configured");
        }
        ReminderConfiguration config = this.getConfiguration(practice);
        boolean disableSMS = this.practiceService.getSMS() == null;
        Date startTime = this.getStartTime();
        Date maxLeadTime = config.getMaxLeadTime(startTime);
        Date due = DateRules.getDate((Date)maxLeadTime, (int)1, (DateUnits)DateUnits.DAYS);
        int pageSize = this.getPageSize();
        ReminderQueueIterator iterator = new ReminderQueueIterator(due, pageSize, this.service);
        this.queued = 0;
        this.cancelled = 0;
        this.errors = 0;
        this.skipped = 0;
        ReminderProcessor processor = this.createProcessor(startTime, config, disableSMS);
        while (!this.stop && iterator.hasNext()) {
            Act reminder = (Act)iterator.next();
            QueueStatus status = this.queue(reminder, processor);
            if (status == QueueStatus.QUEUED) {
                ++this.queued;
            } else if (status == QueueStatus.CANCELLED) {
                ++this.cancelled;
            } else if (status == QueueStatus.ERROR) {
                ++this.errors;
            } else {
                ++this.skipped;
            }
            if (status == QueueStatus.SKIPPED) continue;
            iterator.updated();
        }
    }

    protected ReminderProcessor createProcessor(Date date, ReminderConfiguration config, boolean disableSMS) {
        return new ReminderProcessor(date, config, disableSMS, this.service, this.rules);
    }

    protected QueueStatus queue(Act reminder, ReminderProcessor processor) {
        RetryableProcessor action = this.createRetryableProcessor(reminder, processor);
        Retryer.run((Retryable)action, (int)2);
        return action.getStatus();
    }

    protected RetryableProcessor createRetryableProcessor(Act reminder, ReminderProcessor processor) {
        return new RetryableProcessor(reminder, processor);
    }

    protected ReminderConfiguration getConfiguration(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        IMObject config = bean.getTarget("reminderConfiguration", Policies.active());
        if (config == null) {
            throw new IllegalStateException("Patient reminders have not been configured");
        }
        return new ReminderConfiguration(config, (ArchetypeService)this.service);
    }

    protected Date getStartTime() {
        return new Date();
    }

    protected int getPageSize() {
        return 1000;
    }

    private void complete(Throwable exception, long begin) {
        Set<User> users;
        if (log.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - begin;
            double seconds = (double)elapsed / 1000.0;
            log.info((Object)("Reminders queued=" + this.queued + ", cancelled=" + this.cancelled + ", errors=" + this.errors + ", skipped=" + this.skipped + ", in " + seconds + "s"));
        }
        if (!(exception == null && this.queued == 0 && this.cancelled == 0 && this.errors == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, exception);
        }
    }

    private void notifyUsers(Set<User> users, Throwable exception) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"patientreminderqueue.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"patientreminderqueue.exception", (Object[])new Object[]{exception.getMessage()})).append("\n\n");
        } else if (this.errors != 0) {
            reason = "ERROR";
            subject = Messages.format((String)"patientreminderqueue.subject.errors", (Object[])new Object[]{this.configuration.getName(), this.errors});
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"patientreminderqueue.subject.success", (Object[])new Object[]{this.configuration.getName(), this.queued});
        }
        text.append(Messages.format((String)"patientreminderqueue.queued", (Object[])new Object[]{this.queued})).append('\n');
        text.append(Messages.format((String)"patientreminderqueue.cancelled", (Object[])new Object[]{this.cancelled})).append('\n');
        text.append(Messages.format((String)"patientreminderqueue.errors", (Object[])new Object[]{this.errors})).append('\n');
        text.append(Messages.format((String)"patientreminderqueue.skipped", (Object[])new Object[]{this.skipped})).append('\n');
        this.notifier.send(users, subject, reason, text.toString());
    }

    static enum QueueStatus {
        SKIPPED,
        QUEUED,
        CANCELLED,
        ERROR;

    }

    protected class RetryableProcessor
    extends AbstractRetryable {
        private final Act reminder;
        private final ReminderProcessor processor;
        private QueueStatus status;
        private QueueStatus preCommitStatus;

        public RetryableProcessor(Act reminder, ReminderProcessor processor) {
            this.reminder = reminder;
            this.processor = processor;
        }

        public QueueStatus getStatus() {
            return this.status != null ? this.status : QueueStatus.SKIPPED;
        }

        protected boolean runFirst() {
            return this.queue(this.reminder, this.processor, true);
        }

        protected boolean runAction() {
            return this.queue(this.reminder, this.processor, false);
        }

        protected boolean queue(Act reminder, ReminderProcessor processor, boolean first) {
            this.status = null;
            this.preCommitStatus = null;
            TransactionTemplate template = new TransactionTemplate(PatientReminderQueueJob.this.transactionManager);
            Boolean result = (Boolean)template.execute(status -> this.doQueue(reminder, processor, first));
            this.status = this.preCommitStatus;
            return result != null && result != false;
        }

        private boolean doQueue(Act reminder, ReminderProcessor processor, boolean first) {
            List acts;
            Act act;
            if (!first) {
                act = (Act)PatientReminderQueueJob.this.service.get(reminder.getObjectReference(), Act.class);
                if (act == null) {
                    return false;
                }
            } else {
                act = reminder;
            }
            if (!(acts = processor.process(act)).isEmpty()) {
                PatientReminderQueueJob.this.service.save((Collection)acts);
                if ("CANCELLED".equals(reminder.getStatus())) {
                    this.preCommitStatus = QueueStatus.CANCELLED;
                } else {
                    for (Act saved : acts) {
                        if (!TypeHelper.isA((IMObject)saved, (String)"act.patientReminderItem*") || !"ERROR".equals(saved.getStatus())) continue;
                        this.preCommitStatus = QueueStatus.ERROR;
                        break;
                    }
                    if (this.preCommitStatus == null) {
                        this.preCommitStatus = QueueStatus.QUEUED;
                    }
                }
            }
            return true;
        }
    }
}

