/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;

class Email {
    private final Message message;

    public Email(Message message) {
        this.message = message;
    }

    public String getMessageId() {
        return this.getHeader(() -> {
            if (this.message instanceof MimeMessage) {
                return ((MimeMessage)this.message).getMessageID();
            }
            return null;
        });
    }

    public String getSubject() {
        return this.getHeader(() -> ((Message)this.message).getSubject());
    }

    public String getFrom() {
        return this.getHeader(() -> {
            Address[] from = this.message.getFrom();
            return from != null && from.length > 0 ? from[0].toString() : null;
        });
    }

    public Date getDate() {
        try {
            return this.message.getReceivedDate();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Multipart getParts() throws MessagingException, IOException {
        Multipart result = null;
        Object content = this.message.getContent();
        if (content instanceof Multipart) {
            result = (Multipart)content;
        }
        return result;
    }

    public void setProcessed() throws MessagingException {
        this.message.setFlags(new Flags(Flags.Flag.SEEN), true);
    }

    public void move(Folder source, Folder target) throws MessagingException {
        boolean copy;
        block4: {
            copy = true;
            if (source instanceof IMAPFolder) {
                IMAPFolder folder = (IMAPFolder)source;
                Message[] messages = new Message[]{this.message};
                try {
                    folder.moveMessages(messages, target);
                    copy = false;
                }
                catch (MessagingException exception) {
                    if ("MOVE not supported".equals(exception.getMessage())) break block4;
                    throw exception;
                }
            }
        }
        if (copy) {
            source.copyMessages(new Message[]{this.message}, target);
            this.message.setFlags(new Flags(Flags.Flag.DELETED), true);
        }
    }

    private String getHeader(Callable<String> call) {
        String result = null;
        try {
            result = call.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null ? result : null;
    }
}

