/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.account;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.account.AccountReminder;
import org.openvpms.web.jobs.account.AccountReminderConfig;
import org.openvpms.web.jobs.account.AccountReminderSender;
import org.openvpms.web.jobs.util.ArchetypeServices;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.customer.account.AccountReminderEvaluator;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

@DisallowConcurrentExecution
public class AccountReminderJob
implements InterruptableJob {
    private final Entity configuration;
    private final SimpleSMSService smsService;
    private final ArchetypeServices services;
    private final LookupService lookups;
    private final CustomerRules customerRules;
    private final AccountReminderRules reminderRules;
    private final PracticeService practiceService;
    private final SMSTemplateEvaluator templateEvaluator;
    private final PlatformTransactionManager transactionManager;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    private int total;
    private int sent;
    private int errors;
    private int cancelled;
    private static final Logger log = LoggerFactory.getLogger(AccountReminderJob.class);

    public AccountReminderJob(Entity configuration, SimpleSMSService smsService, ArchetypeServices services, LookupService lookups, CustomerRules customerRules, AccountReminderRules reminderRules, PracticeService practiceService, SMSTemplateEvaluator templateEvaluator, PlatformTransactionManager transactionManager) {
        this.configuration = configuration;
        this.smsService = smsService;
        this.services = services;
        this.lookups = lookups;
        this.customerRules = customerRules;
        this.reminderRules = reminderRules;
        this.practiceService = practiceService;
        this.templateEvaluator = templateEvaluator;
        this.transactionManager = transactionManager;
        this.notifier = new JobCompletionNotifier((IArchetypeService)services.getRuleService());
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.execute();
            this.complete(null);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(exception);
        }
    }

    protected void execute() {
        AccountReminderConfig config = new AccountReminderConfig(this.configuration, this.getStartDate(), (ArchetypeService)this.services.getService());
        this.total = 0;
        this.sent = 0;
        this.errors = 0;
        this.cancelled = 0;
        Party practice = this.practiceService.getPractice();
        if (practice == null) {
            throw new IllegalStateException("No current practice");
        }
        AccountReminderEvaluator evaluator = new AccountReminderEvaluator(practice, this.templateEvaluator, (ArchetypeService)this.services.getService(), this.lookups);
        AccountReminderSender sender = new AccountReminderSender((ArchetypeService)this.services.getService(), this.customerRules, this.reminderRules, this.smsService, evaluator, config, this.transactionManager);
        for (AccountReminderConfig.ReminderCount count : config.getReminderCounts()) {
            this.send(sender, config, count);
        }
        log.info("Processed {} charges: sent={}, errors={}, cancelled={}, skipped={}", new Object[]{this.total, this.sent, this.errors, this.cancelled, this.total - this.sent - this.errors - this.cancelled});
    }

    protected Date getStartDate() {
        return DateRules.getToday();
    }

    protected int getPageSize() {
        return 1000;
    }

    private void send(AccountReminderSender sender, AccountReminderConfig config, AccountReminderConfig.ReminderCount count) {
        log.info("Sending reminder {} for charges finalised between {} and {}", new Object[]{count.getCount(), DateFormatter.formatDateTime((Date)count.getFrom()), DateFormatter.formatDateTime((Date)count.getTo())});
        NamedQuery query = new NamedQuery("AccountReminderJob.getCharges", new String[]{"id", "archetype"});
        query.setParameter("from", (Object)count.getFrom());
        query.setParameter("to", (Object)count.getTo());
        query.setParameter("count", (Object)count.getCount());
        query.setParameter("minBalance", (Object)config.getMinBalance());
        int pageSize = this.getPageSize();
        query.setMaxResults(pageSize);
        boolean done = false;
        HashSet<Long> exclude = new HashSet<Long>();
        IArchetypeService service = this.services.getService();
        while (!this.stop && !done) {
            IPage page = service.getObjects((IArchetypeQuery)query);
            boolean updated = false;
            for (ObjectSet set : page.getResults()) {
                long id = set.getLong("id");
                if (!exclude.add(id)) continue;
                String archetype = set.getString("archetype");
                updated |= this.send(id, archetype, sender, count);
            }
            if (page.getResults().size() < pageSize) {
                done = true;
                continue;
            }
            if (updated) continue;
            query.setFirstResult(query.getFirstResult() + page.getResults().size());
        }
    }

    private boolean send(long id, String archetype, AccountReminderSender sender, AccountReminderConfig.ReminderCount count) {
        boolean result = false;
        FinancialAct charge = (FinancialAct)this.services.getService().get(archetype, id, FinancialAct.class);
        if (charge != null) {
            ++this.total;
            AccountReminder.Status status = sender.send(charge, count);
            if (status.isPersistent()) {
                result = true;
                if (status == AccountReminder.Status.SENT) {
                    ++this.sent;
                } else if (status == AccountReminder.Status.ERROR) {
                    ++this.errors;
                } else if (status == AccountReminder.Status.CANCELLED) {
                    ++this.cancelled;
                }
            }
        }
        return result;
    }

    private void complete(Throwable exception) {
        Set<User> users;
        if (!(exception == null && this.sent == 0 && this.errors == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, exception);
        }
    }

    private void notifyUsers(Set<User> users, Throwable exception) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"accountreminder.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"accountreminder.exception", (Object[])new Object[]{exception.getMessage()}));
        } else if (this.errors != 0) {
            reason = "ERROR";
            subject = Messages.format((String)"accountreminder.subject.errors", (Object[])new Object[]{this.configuration.getName(), this.errors});
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"accountreminder.subject.success", (Object[])new Object[]{this.configuration.getName(), this.sent});
        }
        text.append(Messages.format((String)"accountreminder.sent", (Object[])new Object[]{this.sent}));
        text.append("\n");
        text.append(Messages.format((String)"accountreminder.error", (Object[])new Object[]{this.errors}));
        if (this.errors != 0) {
            text.append("\n\n");
            text.append(Messages.format((String)"accountreminder.error.see", (Object[])new Object[]{this.errors}));
        }
        this.notifier.send(users, subject, reason, text.toString());
    }
}

