/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AccountReminderConfig {
    private final Entity config;
    private final BigDecimal minBalance;
    private final List<ReminderCount> counts = new ArrayList<ReminderCount>();

    public AccountReminderConfig(Entity config, Date date, ArchetypeService service) {
        this.config = config;
        IMObjectBean bean = service.getBean((IMObject)config);
        Period ignoreInterval = PeriodHelper.getPeriod((IMObjectBean)bean, (String)"ignoreInterval");
        if (ignoreInterval == null) {
            ignoreInterval = Period.years((int)1);
        }
        Date start = DateRules.minus((Date)date, (Period)ignoreInterval);
        ArrayList entities = new ArrayList(bean.getTargets("reminders", Entity.class));
        entities.sort((o1, o2) -> {
            Period interval1 = this.getInterval((Entity)o1, service);
            Period interval2 = this.getInterval((Entity)o2, service);
            return -DateRules.plus((Date)date, (Period)interval1).compareTo(DateRules.plus((Date)date, (Period)interval2));
        });
        int i = entities.size();
        for (Entity entity : entities) {
            ReminderCount count = new ReminderCount(entity, --i, service);
            count.setFrom(start);
            Date end = DateRules.minus((Date)date, (Period)count.getInterval());
            count.setTo(end);
            this.counts.add(count);
            start = end;
        }
        Collections.reverse(this.counts);
        this.minBalance = bean.getBigDecimal("minBalance", BigDecimal.ZERO);
    }

    public String getName() {
        return this.config.getName();
    }

    public List<ReminderCount> getReminderCounts() {
        return this.counts;
    }

    public BigDecimal getMinBalance() {
        return this.minBalance;
    }

    public Entity getConfig() {
        return this.config;
    }

    public Date getNextReminder(Date from, int count) {
        Date result = null;
        if (from != null && count + 1 < this.counts.size()) {
            result = DateRules.plus((Date)from, (Period)this.counts.get(count + 1).getInterval());
        }
        return result;
    }

    private Period getInterval(Entity count, ArchetypeService service) {
        Period period = PeriodHelper.getPeriod((IMObjectBean)service.getBean((IMObject)count), (String)"interval", (String)"units");
        return period != null ? period : Period.days((int)0);
    }

    public static class ReminderCount {
        private final int count;
        private final Period interval;
        private final Entity smsTemplate;
        private Date from;
        private Date to;

        public ReminderCount(Entity config, int count, ArchetypeService service) {
            this.count = count;
            IMObjectBean bean = service.getBean((IMObject)config);
            this.interval = PeriodHelper.getPeriod((IMObjectBean)bean, (String)"interval", (String)"units", (DateUnits)DateUnits.DAYS);
            this.smsTemplate = (Entity)bean.getTarget("smsTemplate", Entity.class);
        }

        public int getCount() {
            return this.count;
        }

        public Period getInterval() {
            return this.interval;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public Entity getSMSTemplate() {
            return this.smsTemplate;
        }

        private void setFrom(Date date) {
            this.from = date;
        }

        private void setTo(Date date) {
            this.to = date;
        }
    }
}

