/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.statement;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.apache.commons.lang3.time.StopWatch;
import org.openvpms.archetype.rules.finance.statement.StatementService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPeriodJob
implements InterruptableJob {
    private final IMObjectBean config;
    private final StatementService statementService;
    private final IArchetypeService service;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    private static final Logger log = LoggerFactory.getLogger(EndPeriodJob.class);

    public EndPeriodJob(Entity config, StatementService statementService, IArchetypeRuleService service) {
        this.config = service.getBean((IMObject)config);
        this.statementService = statementService;
        this.service = service;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) {
        Processor processor = this.createProcessor();
        try {
            this.process(processor);
            this.complete(processor, null);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(processor, exception);
        }
    }

    protected void process(Processor processor) {
        while (!this.stop && processor.hasNext()) {
            processor.process();
        }
    }

    protected Date getStatementDate() {
        Date yesterday = DateRules.getPreviousDate((Date)this.getNow());
        Date statementDate = DateRules.getMonthEnd((Date)yesterday);
        if (statementDate.compareTo(yesterday) > 0) {
            statementDate = DateRules.getMonthEnd((Date)DateRules.getDate((Date)statementDate, (int)-1, (DateUnits)DateUnits.MONTHS));
        }
        return statementDate;
    }

    protected Date getNow() {
        return new Date();
    }

    protected Iterator<Party> getCustomers() {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Party.class);
        Root from = query.from(Party.class, new String[]{"party.customerperson"});
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return new TypedQueryIterator(this.service.createQuery(query), 1000);
    }

    private Processor createProcessor() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Iterator<Party> iterator = this.getCustomers();
        boolean postCompletedCharges = this.config.getBoolean("postCompletedCharges");
        return new Processor(this.getStatementDate(), iterator, postCompletedCharges, stopWatch);
    }

    private void complete(Processor processor, Throwable exception) {
        Set<User> users = this.notifier.getUsers((Entity)this.config.getObject(Entity.class));
        if (!users.isEmpty()) {
            this.notifyUsers(users, processor, exception);
        }
    }

    private void notifyUsers(Set<User> users, Processor processor, Throwable exception) {
        String text;
        String subject;
        String reason;
        String date = DateFormatter.formatDate((Date)processor.getStatementDate(), (boolean)false);
        String elapsed = processor.getStopWatch().toString();
        int processed = processor.getProcessed();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"endperiod.exception.subject", (Object[])new Object[]{date});
            text = Messages.format((String)"endperiod.exception.message", (Object[])new Object[]{exception.getMessage(), processed, elapsed});
        } else if (!processor.completed()) {
            reason = "ERROR";
            subject = Messages.format((String)"endperiod.incomplete.subject", (Object[])new Object[]{date});
            text = Messages.format((String)"endperiod.incomplete.message", (Object[])new Object[]{processed, elapsed});
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"endperiod.completed.subject", (Object[])new Object[]{date});
            text = Messages.format((String)"endperiod.completed.message", (Object[])new Object[]{processed, elapsed});
        }
        this.notifier.send(users, subject, reason, text);
    }

    protected class Processor {
        int processed;
        private final Date date;
        private final Iterator<Party> customers;
        private final boolean postCompletedCharges;
        private final StopWatch stopWatch;

        public Processor(Date date, Iterator<Party> customers, boolean postCompletedCharges, StopWatch stopWatch) {
            this.date = date;
            this.customers = customers;
            this.postCompletedCharges = postCompletedCharges;
            this.stopWatch = stopWatch;
        }

        public Date getStatementDate() {
            return this.date;
        }

        public int getProcessed() {
            return this.processed;
        }

        public boolean hasNext() {
            return this.customers.hasNext();
        }

        public void process() {
            Party customer = this.customers.next();
            EndPeriodJob.this.statementService.endPeriod(customer, this.date, this.postCompletedCharges);
            ++this.processed;
        }

        public boolean completed() {
            return !this.customers.hasNext();
        }

        public StopWatch getStopWatch() {
            return this.stopWatch;
        }
    }
}

