/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.scheduledreport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.DefaultMailerFactory;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.MailService;
import org.openvpms.web.component.service.PracticeMailService;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.scheduledreport.ParameterEvaluator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.report.SQLReportPrinter;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ScheduledReportJob
implements InterruptableJob {
    private final IMObjectBean config;
    private final ReportFactory reportFactory;
    private final MailerFactory mailerFactory;
    private final EmailTemplateEvaluator emailTemplateEvaluator;
    private final DocumentHandlers handlers;
    private final PracticeService practiceService;
    private final FileNameFormatter formatter;
    private final DataSource dataSource;
    private final IArchetypeRuleService service;
    private final DocumentJobManager jobManager;
    private final PrinterContext printerContext;
    private final JobCompletionNotifier notifier;
    private Future<?> task;
    private volatile boolean stop;
    private static final Logger log = LoggerFactory.getLogger(ScheduledReportJob.class);
    private static final String PDF = "PDF";
    private static final String CSV = "CSV";

    public ScheduledReportJob(Entity configuration, ReportFactory reportFactory, PracticeMailService mailService, EmailTemplateEvaluator emailTemplateEvaluator, DocumentHandlers handlers, PracticeService practiceService, FileNameFormatter formatter, @Qualifier(value="reportingDataSource") DataSource dataSource, IArchetypeRuleService service, PrinterContextFactory printerContextFactory, DocumentJobManager jobManager) {
        this.config = service.getBean((IMObject)configuration);
        this.reportFactory = reportFactory;
        this.mailerFactory = new DefaultMailerFactory((MailService)mailService, handlers);
        this.emailTemplateEvaluator = emailTemplateEvaluator;
        this.handlers = handlers;
        this.practiceService = practiceService;
        this.formatter = formatter;
        this.dataSource = dataSource;
        this.service = service;
        this.jobManager = jobManager;
        this.printerContext = printerContextFactory.create();
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Future<?> future;
        this.stop = true;
        ScheduledReportJob scheduledReportJob = this;
        synchronized (scheduledReportJob) {
            future = this.task;
        }
        if (future != null && !future.isDone()) {
            log.info("Interrupting current job");
            future.cancel(true);
        }
    }

    public void execute(JobExecutionContext context) {
        State state = new State();
        try {
            this.report(state);
            this.complete(null, state);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(exception, state);
        }
    }

    protected void report(State state) throws IOException, InterruptedException, ExecutionException {
        final DocumentTemplate template = this.getTemplate();
        LocalContext context = new LocalContext();
        context.setPractice(this.practiceService.getPractice());
        context.setLocation((Party)this.config.getTarget("location", Party.class));
        User runAs = (User)this.config.getTarget("runAs", User.class);
        context.setUser(runAs);
        String configReportName = StringUtils.trimToNull((String)this.config.getString("reportName"));
        final String reportName = configReportName != null ? configReportName : template.getName();
        final Lookup format = (Lookup)this.config.getObject("reportNameFormat", Lookup.class);
        state.setTemplate(template);
        SQLReportPrinter printer = new SQLReportPrinter(template, (Context)context, this.reportFactory, this.formatter, this.dataSource, this.printerContext){

            protected String getFileName() {
                String result = format != null ? ScheduledReportJob.this.formatter.format(reportName, null, format) : ScheduledReportJob.this.formatter.format(reportName, null, template);
                return result;
            }
        };
        Set parameterTypes = printer.getParameterTypes();
        ParameterEvaluator evaluator = new ParameterEvaluator();
        Map<String, Object> parameters = evaluator.evaluate(this.config, parameterTypes);
        printer.setParameters(parameters);
        if (!this.stop && this.config.getBoolean("file")) {
            this.file(printer, state, runAs);
        }
        if (!this.stop && this.config.getBoolean("email")) {
            this.email(printer, (Context)context, state, runAs);
        }
        if (!this.stop && this.config.getBoolean("print")) {
            this.print(printer, state, runAs);
        }
    }

    protected DocumentTemplate getTemplate() {
        Entity entity = (Entity)this.config.getTarget("report", Entity.class, Policies.active());
        if (entity == null) {
            throw new IllegalStateException(this.config.getDisplayName() + " has no active report: " + this.config.getObject().getName());
        }
        return new DocumentTemplate(entity, (ArchetypeService)this.service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getResult(Future<T> future) throws ExecutionException, InterruptedException {
        ScheduledReportJob scheduledReportJob = this;
        synchronized (scheduledReportJob) {
            this.task = future;
        }
        return future.get();
    }

    private void file(SQLReportPrinter printer, State state, User user) throws IOException, ExecutionException, InterruptedException {
        String mimeType;
        String fileType = this.config.getString("fileType");
        if (PDF.equals(fileType)) {
            mimeType = "application/pdf";
        } else if (CSV.equals(fileType)) {
            mimeType = "text/csv";
        } else {
            throw new IllegalStateException("Unrecognised file type: " + fileType);
        }
        Document document = this.getDocument(printer, mimeType, user);
        File file = new File(this.config.getString("directory"), document.getName());
        DocumentHandler handler = this.handlers.get(document);
        FileUtils.copyInputStreamToFile((InputStream)handler.getContent(document), (File)file);
        state.setFile(file);
    }

    private Document getDocument(SQLReportPrinter printer, String mimeType, User user) throws ExecutionException, InterruptedException {
        Job job = JobBuilder.newJob((String)printer.getDisplayName(), (User)user).get(() -> printer.getDocument(mimeType, false)).build();
        Future future = this.jobManager.run(job);
        return (Document)this.getResult(future);
    }

    private void email(SQLReportPrinter printer, Context context, State state, User user) throws ExecutionException, InterruptedException {
        String body;
        String subject;
        String name;
        String mimeType;
        String type = this.config.getString("attachmentType");
        if (PDF.equals(type)) {
            mimeType = "application/pdf";
        } else if (CSV.equals(type)) {
            mimeType = "text/csv";
        } else {
            throw new IllegalStateException("Unrecognised attachment type: " + type);
        }
        Document document = this.getDocument(printer, mimeType, user);
        Mailer mailer = this.mailerFactory.create((MailContext)new PracticeMailContext(context));
        String from = this.config.getString("emailFrom");
        ArrayList<String> to = new ArrayList<String>();
        int i = 0;
        while (this.config.hasNode(name = "emailTo" + i)) {
            String address = this.config.getString(name);
            if (!StringUtils.isEmpty((CharSequence)address)) {
                to.add(address);
            }
            ++i;
        }
        EmailTemplate emailTemplate = state.getTemplate().getEmailTemplate();
        if (emailTemplate != null) {
            subject = this.emailTemplateEvaluator.getSubject(emailTemplate, null, context);
            body = this.emailTemplateEvaluator.getMessage(emailTemplate, null, context);
        } else {
            String name2 = this.config.getObject().getName();
            subject = Messages.format((String)"scheduledreport.email.subject", (Object[])new Object[]{name2});
            body = Messages.format((String)"scheduledreport.email.message", (Object[])new Object[]{name2});
        }
        mailer.setFrom(from);
        mailer.setTo(to.toArray(new String[0]));
        mailer.setSubject(subject);
        mailer.setBody(body);
        mailer.addAttachment(document);
        if (emailTemplate != null) {
            for (DocumentTemplate template : emailTemplate.getAttachments(true)) {
                Document attachment = template.getDocument();
                if (attachment == null) continue;
                mailer.addAttachment(attachment);
            }
        }
        mailer.send();
        state.setEmail(StringUtils.join(to, (String)"; "));
    }

    private void print(SQLReportPrinter printer, State state, User user) throws InterruptedException, ExecutionException {
        DocumentPrinter documentPrinter;
        PrinterReference reference = PrinterReference.fromString((String)this.config.getString("printer"));
        DocumentPrinterServiceLocator printerLocator = printer.getPrinterLocator();
        if (reference != null) {
            documentPrinter = printerLocator.getPrinter(reference.getArchetype(), reference.getId());
            if (documentPrinter == null) {
                throw new IllegalStateException("Cannot print report. Printer " + reference + " not found");
            }
        } else {
            documentPrinter = printer.getDefaultPrinter();
            if (documentPrinter == null) {
                throw new IllegalStateException("Cannot print report. There is no default printer");
            }
        }
        Job job = JobBuilder.newJob((String)printer.getDisplayName(), (User)user).run(() -> printer.print(documentPrinter)).build();
        Future future = this.jobManager.run(job);
        this.getResult(future);
        state.setPrinter(documentPrinter.getName());
    }

    private void complete(Throwable exception, State state) {
        Set<User> users;
        if ((exception != null || this.config.getBoolean("notifyOnSuccess")) && !(users = this.notifier.getUsers((Entity)this.config.getObject(Entity.class))).isEmpty()) {
            this.notifyUsers(users, state, exception);
        }
    }

    private void notifyUsers(Set<User> users, State state, Throwable exception) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"scheduledreport.exception.subject", (Object[])new Object[]{this.config.getObject().getName()});
            text.append(Messages.format((String)"scheduledreport.exception.message", (Object[])new Object[]{exception.getMessage()}));
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"scheduledreport.subject", (Object[])new Object[]{this.config.getObject().getName(), state.getElapsed()});
            if (state.getFile() != null) {
                text.append(Messages.format((String)"scheduledreport.filed", (Object[])new Object[]{state.getFile()}));
                text.append('\n');
            }
            if (state.getEmail() != null) {
                text.append(Messages.format((String)"scheduledreport.emailed", (Object[])new Object[]{state.getEmail()}));
                text.append('\n');
            }
            if (state.getPrinter() != null) {
                text.append(Messages.format((String)"scheduledreport.printed", (Object[])new Object[]{state.getPrinter()}));
            }
        }
        this.notifier.send(users, subject, reason, text.toString());
    }

    private static class State {
        private final StopWatch stopWatch = new StopWatch();
        private File file;
        private String to;
        private String printer;
        private DocumentTemplate template;

        public State() {
            this.stopWatch.start();
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setEmail(String to) {
            this.to = to;
        }

        public String getEmail() {
            return this.to;
        }

        public void setPrinter(String printer) {
            this.printer = printer;
        }

        public String getPrinter() {
            return this.printer;
        }

        public String getElapsed() {
            return this.stopWatch.toString();
        }

        public void setTemplate(DocumentTemplate template) {
            this.template = template;
        }

        public DocumentTemplate getTemplate() {
            return this.template;
        }
    }
}

