/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.reminder;

import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.GroupingReminderIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderGroupingPolicy;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.scheduler.SingletonJob;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.mail.DefaultMailerFactory;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.service.MailService;
import org.openvpms.web.component.service.PracticeMailService;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.reminder.Stats;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSProcessor;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientReminderSenderJob
implements InterruptableJob,
SingletonJob {
    private final Entity configuration;
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final ReminderRules reminderRules;
    private final PatientRules patientRules;
    private final PracticeRules practiceRules;
    private final MailerFactory mailerFactory;
    private final EmailTemplateEvaluator emailTemplateEvaluator;
    private final ReporterFactory reporterFactory;
    private final SimpleSMSService smsService;
    private final ReminderSMSEvaluator smsEvaluator;
    private final CommunicationLogger communicationLogger;
    private final MailPasswordResolver passwordResolver;
    private final ActionFactory actionFactory;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    private static final Logger log = LoggerFactory.getLogger(PatientReminderSenderJob.class);

    public PatientReminderSenderJob(Entity configuration, IArchetypeRuleService service, PracticeService practiceService, ReminderRules reminderRules, PatientRules patientRules, PracticeRules practiceRules, PracticeMailService mailService, DocumentHandlers handlers, EmailTemplateEvaluator emailTemplateEvaluator, ReporterFactory reporterFactory, SimpleSMSService smsService, ReminderSMSEvaluator smsEvaluator, CommunicationLogger communicationLogger, MailPasswordResolver passwordResolver, ActionFactory actionFactory) {
        this.configuration = configuration;
        this.service = service;
        this.practiceService = practiceService;
        this.reminderRules = reminderRules;
        this.patientRules = patientRules;
        this.practiceRules = practiceRules;
        this.mailerFactory = this.getMailerFactory((MailService)mailService, handlers);
        this.emailTemplateEvaluator = emailTemplateEvaluator;
        this.reporterFactory = reporterFactory;
        this.smsService = smsService;
        this.smsEvaluator = smsEvaluator;
        this.communicationLogger = communicationLogger;
        this.passwordResolver = passwordResolver;
        this.actionFactory = actionFactory;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) {
        long begin = System.currentTimeMillis();
        Stats total = Stats.ZERO;
        try {
            Party practice = this.practiceService.getPractice();
            if (practice == null) {
                throw new IllegalStateException("Practice is not configured");
            }
            CommunicationLogger logger = CommunicationHelper.isLoggingEnabled((Party)practice, (IArchetypeService)this.service) ? this.communicationLogger : null;
            ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)this.service);
            ReminderConfiguration config = this.getReminderConfig(practice);
            if (config.getLocation() == null) {
                throw new IllegalStateException("Reminder Configuration does not specify a Location");
            }
            Date date = this.getSendDate();
            Date cancelDate = this.getCancelDate();
            total = this.sendEmailReminders(date, cancelDate, reminderTypes, practice, config, logger);
            if (!this.stop) {
                Stats stats = this.sendSMSReminders(date, cancelDate, reminderTypes, practice, config);
                total = total.add(stats);
            }
            this.complete(null, begin, total);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(exception, begin, total);
        }
    }

    protected Stats sendEmailReminders(Date date, Date cancelDate, ReminderTypes reminderTypes, Party practice, ReminderConfiguration config, CommunicationLogger logger) {
        ReminderEmailProcessor processor = new ReminderEmailProcessor(this.mailerFactory, this.emailTemplateEvaluator, this.reporterFactory, reminderTypes, practice, this.reminderRules, this.patientRules, this.practiceRules, this.service, config, logger, this.passwordResolver, this.actionFactory);
        GroupingReminderIterator iterator = this.createIterator("act.patientReminderItemEmail", reminderTypes, date, config);
        return this.send((PatientReminders)cancelDate, (PatientReminderProcessor)processor, iterator);
    }

    protected Stats sendSMSReminders(Date date, Date cancelDate, ReminderTypes reminderTypes, Party practice, ReminderConfiguration config) {
        ReminderSMSProcessor sender = new ReminderSMSProcessor(this.smsService, this.smsEvaluator, reminderTypes, practice, this.reminderRules, this.patientRules, (ArchetypeService)this.service, config, this.actionFactory);
        GroupingReminderIterator iterator = this.createIterator("act.patientReminderItemSMS", reminderTypes, date, config);
        return this.send((PatientReminders)cancelDate, (PatientReminderProcessor)sender, iterator);
    }

    protected ReminderConfiguration getReminderConfig(Party practice) {
        ReminderConfiguration config = this.reminderRules.getConfiguration(practice);
        if (config == null) {
            throw new IllegalStateException("Patient reminders have not been configured");
        }
        return config;
    }

    protected Date getSendDate() {
        return DateRules.getTomorrow();
    }

    protected Date getCancelDate() {
        return new Date();
    }

    protected int getPageSize() {
        return 1000;
    }

    MailerFactory getMailerFactory(MailService mailService, DocumentHandlers handlers) {
        return new DefaultMailerFactory(mailService, handlers);
    }

    private <T extends PatientReminders> Stats send(Date cancelDate, PatientReminderProcessor<T> processor, GroupingReminderIterator iterator) {
        Stats total = new Stats();
        while (!this.stop && iterator.hasNext()) {
            Reminders reminders = iterator.next();
            try {
                PatientReminders state = processor.prepare(reminders.getReminders(), reminders.getGroupBy(), cancelDate, false);
                Stats stats = this.send(state, processor, iterator);
                total = total.add(stats);
            }
            catch (Throwable exception) {
                log.error("Failed to send reminders", exception);
                total = total.add(new Stats(0, 0, reminders.getReminders().size()));
            }
        }
        return total;
    }

    private <T extends PatientReminders> Stats send(T reminders, PatientReminderProcessor<T> processor, GroupingReminderIterator iterator) {
        int errors;
        int processed;
        boolean updated;
        try {
            if (reminders.canSend()) {
                processor.process(reminders);
            }
            updated = processor.complete(reminders);
            processed = reminders.getProcessed();
            errors = reminders.getErrors().size();
        }
        catch (Throwable exception) {
            processed = 0;
            errors = reminders.getErrors().size() + reminders.getUnsaved().size();
            updated = processor.failed(reminders, exception);
        }
        if (updated) {
            iterator.updated();
        }
        int cancelled = reminders.getCancelled().size();
        return new Stats(processed, cancelled, errors);
    }

    private void complete(Throwable exception, long begin, Stats stats) {
        Set<User> users;
        if (log.isInfoEnabled()) {
            long elapsed = System.currentTimeMillis() - begin;
            double seconds = (double)elapsed / 1000.0;
            log.info("Reminders sent={}, cancelled={}, errors={}, in {}s", new Object[]{stats.getSent(), stats.getCancelled(), stats.getErrors(), seconds});
        }
        if (!(exception == null && stats.getSent() == 0 && stats.getCancelled() == 0 && stats.getErrors() == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, exception, stats);
        }
    }

    private void notifyUsers(Set<User> users, Throwable exception, Stats stats) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"patientremindersender.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"patientremindersender.exception", (Object[])new Object[]{exception.getMessage()})).append("\n\n");
        } else if (stats.getErrors() != 0) {
            reason = "ERROR";
            subject = Messages.format((String)"patientremindersender.subject.errors", (Object[])new Object[]{this.configuration.getName(), stats.getErrors()});
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"patientremindersender.subject.success", (Object[])new Object[]{this.configuration.getName(), stats.getSent()});
        }
        text.append(Messages.format((String)"patientremindersender.sent", (Object[])new Object[]{stats.getSent()})).append('\n');
        text.append(Messages.format((String)"patientremindersender.cancelled", (Object[])new Object[]{stats.getCancelled()})).append('\n');
        text.append(Messages.format((String)"patientremindersender.errors", (Object[])new Object[]{stats.getErrors()})).append('\n');
        this.notifier.send(users, subject, reason, text.toString());
    }

    private GroupingReminderIterator createIterator(String shortName, ReminderTypes reminderTypes, Date date, ReminderConfiguration config) {
        ReminderItemQueryFactory factory = new ReminderItemQueryFactory(shortName, "PENDING");
        factory.setTo(date);
        ReminderGroupingPolicy groupByCustomer = config.getGroupByCustomerPolicy();
        ReminderGroupingPolicy groupByPatient = config.getGroupByPatientPolicy();
        return new GroupingReminderIterator(factory, reminderTypes, this.getPageSize(), groupByCustomer, groupByPatient, this.service);
    }
}

