/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.recordlocking;

import java.util.Objects;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.event.Listener;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MedicalRecordLockingScheduler
implements DisposableBean {
    protected static final String JOB_SHORT_NAME = "entity.jobMedicalRecordLocker";
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final PracticeRules rules;
    private final Listener<PracticeService.Update> listener;
    private final PlatformTransactionManager transactionManager;
    private Period period;
    private static final Logger log = LoggerFactory.getLogger(MedicalRecordLockingScheduler.class);

    public MedicalRecordLockingScheduler(IArchetypeService service, PracticeService practiceService, PracticeRules rules, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.practiceService = practiceService;
        this.rules = rules;
        this.transactionManager = transactionManager;
        Party practice = practiceService.getPractice();
        if (practice != null) {
            this.init(practice, null, true);
        } else {
            log.error("Medical record locking cannot be enabled until a Practice is configured");
        }
        this.listener = update -> this.init(update.getPractice(), update.getUser(), false);
        practiceService.addListener(this.listener);
    }

    public void destroy() {
        this.practiceService.removeListener(this.listener);
    }

    private void init(Party practice, String updatedBy, boolean audit) {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            log.error("Medical Record Locking cannot be enabled until a Practice Service User is configured");
        } else {
            try {
                RunAs.run((User)user, () -> this.init(practice, updatedBy, user, audit));
            }
            catch (Throwable exception) {
                log.error("An error was encountered initialising Medical Record Locking: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    private void init(Party practice, final String updatedBy, final User user, final boolean audit) {
        final Period newPeriod = this.rules.getRecordLockPeriod(practice);
        if (newPeriod == null) {
            boolean enabled = this.disable();
            if (audit || enabled) {
                String subject = updatedBy != null ? Messages.format((String)"recordlocking.disabled.subjectby", (Object[])new Object[]{updatedBy}) : Messages.get((String)"recordlocking.disabled.subject");
                this.audit(subject, Messages.get((String)"recordlocking.disabled.message"), user);
            }
        } else {
            TransactionTemplate template = new TransactionTemplate(this.transactionManager);
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    Period current;
                    boolean disabled = MedicalRecordLockingScheduler.this.enable(user);
                    1 var4_3 = this;
                    synchronized (var4_3) {
                        current = MedicalRecordLockingScheduler.this.period;
                    }
                    if (audit || disabled || !Objects.equals(current, newPeriod)) {
                        String subject = updatedBy != null && (disabled || !Objects.equals(current, newPeriod)) ? Messages.format((String)"recordlocking.enabled.subjectby", (Object[])new Object[]{updatedBy}) : Messages.get((String)"recordlocking.enabled.subject");
                        String periodStr = PeriodFormat.getDefault().print((ReadablePeriod)newPeriod);
                        MedicalRecordLockingScheduler.this.audit(subject, Messages.format((String)"recordlocking.enabled.message", (Object[])new Object[]{periodStr}), user);
                    }
                    var4_3 = this;
                    synchronized (var4_3) {
                        MedicalRecordLockingScheduler.this.period = newPeriod;
                    }
                }
            });
        }
    }

    private void audit(String subject, String message, User user) {
        log.info(subject);
        log.info(message);
        Act act = (Act)this.service.create("act.auditMessage", Act.class);
        IMObjectBean bean = this.service.getBean((org.openvpms.component.model.object.IMObject)act);
        bean.setTarget("to", (org.openvpms.component.model.object.IMObject)user);
        bean.setValue("reason", (Object)"MEDICAL_RECORD_LOCKING");
        bean.setValue("description", (Object)subject);
        bean.setValue("message", (Object)message);
        this.service.save((org.openvpms.component.model.object.IMObject)act);
    }

    private boolean enable(User user) {
        boolean result = false;
        IMObjectQueryIterator<org.openvpms.component.model.object.IMObject> active = this.getJobs(true);
        if (!active.hasNext()) {
            IMObjectQueryIterator<org.openvpms.component.model.object.IMObject> inactive = this.getJobs(false);
            if (inactive.hasNext()) {
                org.openvpms.component.model.object.IMObject object = (org.openvpms.component.model.object.IMObject)inactive.next();
                this.setActive(object, true);
            } else {
                IMObject config = this.service.create(JOB_SHORT_NAME);
                IMObjectBean bean = this.service.getBean((org.openvpms.component.model.object.IMObject)config);
                bean.setTarget("runAs", (org.openvpms.component.model.object.IMObject)user);
                this.service.save((org.openvpms.component.model.object.IMObject)config);
            }
            result = true;
        }
        return result;
    }

    private boolean disable() {
        int count = 0;
        IMObjectQueryIterator<org.openvpms.component.model.object.IMObject> iterator = this.getJobs(true);
        try {
            while (iterator.hasNext()) {
                org.openvpms.component.model.object.IMObject object = (org.openvpms.component.model.object.IMObject)iterator.next();
                if (!object.isActive()) continue;
                this.setActive(object, false);
                ++count;
            }
        }
        catch (Throwable exception) {
            log.error("Failed to disable job", exception);
        }
        return count > 0;
    }

    private void setActive(org.openvpms.component.model.object.IMObject object, boolean active) {
        object.setActive(active);
        this.service.save(object);
    }

    private IMObjectQueryIterator<org.openvpms.component.model.object.IMObject> getJobs(boolean active) {
        ArchetypeQuery query = new ArchetypeQuery(JOB_SHORT_NAME, active);
        query.setMaxResults(-1);
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }
}

