/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.recordlocking;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.scheduler.SingletonJob;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.recordlocking.MedicalRecordLocker;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.transaction.PlatformTransactionManager;

public class MedicalRecordLockerJob
implements InterruptableJob,
SingletonJob {
    private final Entity configuration;
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final String[] shortNames;
    private final JobCompletionNotifier notifier;
    private final MedicalRecordLocker locker;
    private volatile boolean stop;
    private static final Log log = LogFactory.getLog(MedicalRecordLockerJob.class);
    private static final int DEFAULT_MAX_RECORDS = 50000;
    private static final int DEFAULT_BATCH_SIZE = 500;

    public MedicalRecordLockerJob(Entity configuration, IArchetypeRuleService service, PracticeService practiceService, SessionFactory factory, MedicalRecordRules recordRules, PlatformTransactionManager transactionManager) {
        this.configuration = configuration;
        this.service = service;
        this.practiceService = practiceService;
        this.shortNames = recordRules.getLockableRecords();
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
        this.locker = new MedicalRecordLocker(factory, transactionManager);
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        long begin = System.currentTimeMillis();
        int locked = 0;
        try {
            Date startTime = this.getStartTime();
            locked = this.lock(startTime);
            this.complete(null, locked, begin);
        }
        catch (Throwable exception) {
            log.error((Object)exception, exception);
            this.complete(exception, locked, begin);
        }
    }

    protected int lock(Date startTime) {
        int maxRecords;
        IMObjectBean bean;
        int batchSize;
        int count = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("MedicalRecordLockerJob locking: " + StringUtils.join((Object[])this.shortNames, (String)", ")));
            log.debug((Object)("Locking records starting on or before: " + DateFormatter.formatDateTime((Date)startTime)));
        }
        if ((batchSize = (bean = this.service.getBean((IMObject)this.configuration)).getInt("batchSize", 500)) <= 0) {
            batchSize = 500;
        }
        if ((maxRecords = bean.getInt("maxRecords", 50000)) <= 0) {
            maxRecords = 50000;
        }
        boolean done = false;
        while (!this.stop && !done) {
            int updated = this.locker.lock(this.shortNames, startTime, batchSize);
            if (updated >= batchSize && (count += updated) < maxRecords) continue;
            done = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MedicalRecordLockerJob locked=" + count));
        }
        return count;
    }

    private void complete(Throwable exception, int locked, long begin) {
        Set<User> users;
        long endTime = System.currentTimeMillis();
        long elapsed = endTime - begin;
        if (!(exception == null && locked == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, locked, elapsed, exception);
        }
    }

    private void notifyUsers(Set<User> users, int locked, long elapsed, Throwable exception) {
        String text;
        String subject;
        String reason;
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"recordlocking.exception.subject", (Object[])new Object[]{this.configuration.getName()});
            text = Messages.format((String)"recordlocking.exception.message", (Object[])new Object[]{exception.getMessage()});
        } else {
            reason = "COMPLETED";
            double seconds = (double)elapsed / 1000.0;
            double rate = seconds != 0.0 ? (double)locked / seconds : (double)locked;
            subject = Messages.format((String)"recordlocking.subject", (Object[])new Object[]{this.configuration.getName(), locked});
            text = Messages.format((String)"recordlocking.message", (Object[])new Object[]{locked, seconds, rate});
        }
        this.notifier.send(users, subject, reason, text);
    }

    private Date getStartTime() {
        Period period = this.practiceService.getRecordLockPeriod();
        if (period == null) {
            throw new IllegalStateException("Medical record locking has been disabled");
        }
        Date result = new DateTime().minus((ReadablePeriod)period).toDate();
        return result;
    }
}

