/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class EmailLoaderListener {
    private final List<MailData> loaded = new ArrayList<MailData>();
    private final List<MailData> skipped = new ArrayList<MailData>();
    private final List<MailData> missingId = new ArrayList<MailData>();
    private final List<MailData> missingAct = new ArrayList<MailData>();
    private final List<MailData> errors = new ArrayList<MailData>();
    private final List<MailData> noAttachments = new ArrayList<MailData>();

    EmailLoaderListener() {
    }

    public void loaded(String messageId, String from, String subject, Date date, String name, long id) {
        this.loaded.add(new MailData(messageId, from, subject, date, name, id));
    }

    public List<MailData> getLoaded() {
        return this.loaded;
    }

    public void alreadyLoaded(String messageId, String from, String subject, Date date, String name, long id) {
        this.skipped.add(new MailData(messageId, from, subject, date, name, id));
    }

    public List<MailData> getAlreadyLoaded() {
        return this.skipped;
    }

    public void missingId(String messageId, String from, String subject, Date date, String name) {
        this.missingId.add(new MailData(messageId, from, subject, date, name, -1L));
    }

    public List<MailData> getMissingId() {
        return this.missingId;
    }

    public void missingAct(String messageId, String from, String subject, Date date, String name, long id) {
        this.missingAct.add(new MailData(messageId, from, subject, date, name, id));
    }

    public List<MailData> getMissingAct() {
        return this.missingAct;
    }

    public void noAttachment(String messageId, String from, String subject, Date date) {
        this.noAttachments.add(new MailData(messageId, from, subject, date, null, -1L));
    }

    public List<MailData> getNoAttachments() {
        return this.noAttachments;
    }

    public void error(String messageId, String from, String subject, Date date, String name, Throwable exception) {
        this.errors.add(new MailData(messageId, from, subject, date, name, -1L, exception.getMessage()));
    }

    public void error(String messageId, String from, String subject, Date date, String name, String message) {
        this.errors.add(new MailData(messageId, from, subject, date, name, -1L, message));
    }

    public List<MailData> getErrors() {
        return this.errors;
    }

    public int getProcessed() {
        return this.loaded.size() + this.missingId.size() + this.missingAct.size() + this.skipped.size() + this.noAttachments.size() + this.errors.size();
    }

    public static class MailData {
        private final String messageId;
        private final String from;
        private final String subject;
        private final Date date;
        private final String name;
        private final long id;
        private final String error;

        public MailData(String messageId, String from, String subject, Date date, String name, long id) {
            this(messageId, from, subject, date, name, id, null);
        }

        public MailData(String messageId, String from, String subject, Date date, String name, long id, String error) {
            this.messageId = messageId;
            this.from = from;
            this.subject = subject;
            this.date = date;
            this.name = name;
            this.id = id;
            this.error = error;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getFrom() {
            return this.from;
        }

        public String getSubject() {
            return this.subject;
        }

        public Date getDate() {
            return this.date;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public String getError() {
            return this.error;
        }
    }
}

