/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.SearchTerm;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.web.jobs.docload.email.Email;
import org.openvpms.web.jobs.docload.email.EmailLoader;
import org.openvpms.web.jobs.docload.email.EmailLoaderListener;
import org.openvpms.web.security.mail.MailPasswordResolver;

class EmailFolderLoader {
    private final MailServer mailServer;
    private final MailPasswordResolver passwordResolver;
    private final EmailLoaderListener listener;
    private static final String IMAP_PREFIX = "mail.imap.";
    private static final String IMAPS_PREFIX = "mail.imaps.";
    private static final String CONNECTION_TIMEOUT = "connectiontimeout";
    private static final String READ_TIMEOUT = "timeout";
    private static final String WRITE_TIMEOUT = "writetimeout";
    private static final String IMAP_PROTOCOL = "imap";
    private static final String IMAPS_PROTOCOL = "imaps";

    public EmailFolderLoader(MailServer mailServer, MailPasswordResolver passwordResolver, EmailLoaderListener listener) {
        this.mailServer = mailServer;
        this.passwordResolver = passwordResolver;
        this.listener = listener;
    }

    public void process(EmailLoader loader, List<String> from, String sourceName, String targetName, String errorName, AtomicBoolean stop) throws MessagingException {
        Session session = this.getSession();
        try (Store store = session.getStore();){
            String password = this.passwordResolver.getPassword(this.mailServer);
            store.connect(this.mailServer.getHost(), this.mailServer.getPort(), this.mailServer.getUsername(), password);
            try (Folder source = store.getFolder(sourceName);
                 Folder target = targetName != null ? store.getFolder(targetName) : null;
                 Folder error = errorName != null ? store.getFolder(errorName) : null;){
                Message[] messages;
                source.open(2);
                if (!source.isOpen()) {
                    throw new IllegalStateException("Failed to open folder " + sourceName);
                }
                Flags flags = source.getPermanentFlags();
                if (flags == null || !flags.contains(Flags.Flag.SEEN)) {
                    throw new IllegalStateException("Folder " + sourceName + " does not support the SEEN flag");
                }
                if (target != null) {
                    target.open(2);
                }
                if (error != null) {
                    error.open(2);
                }
                FlagTerm search = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
                if (from != null && !from.isEmpty()) {
                    search = new AndTerm((SearchTerm)search, this.getFromTerm(from));
                }
                for (Message message : messages = source.search((SearchTerm)search)) {
                    if (stop.get()) {
                        break;
                    }
                    Email email = new Email(message);
                    this.process(email, loader, source, target, error);
                }
            }
        }
    }

    private void process(Email email, EmailLoader loader, Folder source, Folder target, Folder error) {
        try {
            boolean processed = loader.process(email);
            email.setProcessed();
            if (processed) {
                if (target != null) {
                    email.move(source, target);
                }
            } else if (error != null) {
                email.move(source, error);
            }
        }
        catch (Throwable exception) {
            this.listener.error(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), null, exception);
        }
    }

    private Session getSession() {
        int timeout;
        String prefix = IMAP_PREFIX;
        String protocol = IMAP_PROTOCOL;
        Properties properties = new Properties();
        if (this.mailServer.getSecurity() == MailServer.Security.SSL_TLS) {
            properties.setProperty("mail.imap.ssl.enable", "true");
            prefix = IMAPS_PREFIX;
            protocol = IMAPS_PROTOCOL;
        } else if (this.mailServer.getSecurity() == MailServer.Security.STARTTLS) {
            properties.setProperty("mail.imap.starttls.enable", "true");
            prefix = IMAPS_PREFIX;
            protocol = IMAPS_PROTOCOL;
        }
        properties.setProperty("mail.store.protocol", protocol);
        if (this.mailServer.getAuthenticationMethod() == MailServer.AuthenticationMethod.OAUTH2) {
            properties.setProperty("mail.imaps.auth.mechanisms", "XOAUTH2");
        }
        if ((timeout = this.mailServer.getTimeout()) > 0) {
            String millis = Long.toString((long)timeout * 1000L);
            properties.setProperty(prefix + READ_TIMEOUT, millis);
            properties.setProperty(prefix + WRITE_TIMEOUT, millis);
            properties.setProperty(prefix + CONNECTION_TIMEOUT, millis);
        }
        return Session.getInstance((Properties)properties);
    }

    private SearchTerm getFromTerm(List<String> from) {
        SearchTerm[] terms = new SearchTerm[from.size()];
        for (int i = 0; i < from.size(); ++i) {
            terms[i] = new FromStringTerm(from.get(i));
        }
        return terms.length == 1 ? terms[0] : new OrTerm(terms);
    }
}

