/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.account;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.jobs.account.AccountReminder;
import org.openvpms.web.jobs.account.AccountReminderConfig;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.account.AccountReminderEvaluator;
import org.openvpms.web.workspace.customer.account.AccountReminderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class AccountReminderSender {
    private final ArchetypeService service;
    private final CustomerRules customerRules;
    private final AccountReminderRules reminderRules;
    private final SimpleSMSService smsService;
    private final AccountReminderEvaluator evaluator;
    private final AccountReminderConfig config;
    private final PlatformTransactionManager transactionManager;
    private final int maxParts;
    private final String subject;
    private static final String REASON = "ACCOUNT_REMINDER";
    private static final Logger log = LoggerFactory.getLogger(AccountReminderSender.class);

    public AccountReminderSender(ArchetypeService service, CustomerRules customerRules, AccountReminderRules reminderRules, SimpleSMSService smsService, AccountReminderEvaluator evaluator, AccountReminderConfig config, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.customerRules = customerRules;
        this.reminderRules = reminderRules;
        this.smsService = smsService;
        this.evaluator = evaluator;
        this.config = config;
        this.transactionManager = transactionManager;
        this.maxParts = smsService.getMaxParts();
        this.subject = Messages.get((String)"sms.log.account.subject");
    }

    public AccountReminder.Status send(FinancialAct charge, AccountReminderConfig.ReminderCount count) {
        AccountReminder reminder = new AccountReminder(charge, count.getCount(), this.customerRules, this.service);
        if (this.needsReminder(charge)) {
            Party customer = reminder.getCustomer();
            if (customer == null) {
                reminder.failed(Messages.get((String)"reporting.reminder.customerinactive"));
            } else {
                Contact contact = reminder.getContact();
                if (contact == null) {
                    reminder.failed(Messages.get((String)"reporting.reminder.nosmscontact"));
                } else {
                    Party location = reminder.getLocation();
                    if (location == null) {
                        String displayName = DescriptorHelper.getDisplayName((String)charge.getArchetype(), (ArchetypeService)this.service);
                        reminder.failed(Messages.format((String)"reporting.reminder.nolocation", (Object[])new Object[]{displayName}));
                    } else {
                        this.send(charge, reminder, count, customer, contact, location);
                    }
                }
            }
        } else {
            reminder.cancel();
        }
        return reminder.getStatus();
    }

    private void send(FinancialAct charge, AccountReminder reminder, AccountReminderConfig.ReminderCount count, Party customer, Contact contact, Party location) {
        try {
            String message = this.evaluator.evaluate(count.getSMSTemplate(), charge, customer, location);
            if (StringUtils.isEmpty((CharSequence)message)) {
                reminder.failed(Messages.get((String)"reporting.reminder.emptysms"), true);
            } else if (this.smsService.getParts(message) > this.maxParts) {
                reminder.failed(Messages.format((String)"reporting.reminder.smstoolong", (Object[])new Object[]{message}), true);
            } else {
                TransactionTemplate template = new TransactionTemplate(this.transactionManager);
                template.executeWithoutResult(transactionStatus -> {
                    this.smsService.send(message, contact, customer, null, this.subject, REASON, location);
                    reminder.sent(this.config.getNextReminder(charge.getActivityEndTime(), count.getCount()));
                });
            }
        }
        catch (AccountReminderException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            reminder.failed(exception.getMessage());
        }
    }

    private boolean needsReminder(FinancialAct charge) {
        return this.reminderRules.needsReminder(charge, this.config.getMinBalance());
    }
}

