/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.account;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccountReminder {
    private final CustomerRules customerRules;
    private final ArchetypeService service;
    private final IMObjectBean bean;
    private final Party customer;
    private final int count;
    private final Set<IMObject> toSave = new HashSet<IMObject>();
    private IMObjectBean reminder;
    private Status status = Status.UNKNOWN;
    private static final Logger log = LoggerFactory.getLogger(AccountReminder.class);
    private static final String CUSTOMER = "customer";
    private static final String LOCATION = "location";
    private static final String STATUS = "status";
    private static final String ERROR = "error";
    private static final String COUNT = "count";
    private static final String REMINDERS = "reminders";
    private static final String CHARGE = "charge";
    private static final String PRACTICE = "practice";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String PROCESSED = "processed";
    private static final String REMINDER_COUNT = "reminderCount";
    private static final String REMINDER_SENT = "reminderSent";

    public AccountReminder(FinancialAct charge, int count, CustomerRules customerRules, ArchetypeService service) {
        this.service = service;
        this.customerRules = customerRules;
        this.bean = service.getBean((IMObject)charge);
        this.count = count;
        this.customer = (Party)this.bean.getTarget(CUSTOMER, Party.class, Policies.active());
        this.reminder = this.init();
    }

    public Party getCustomer() {
        return this.customer;
    }

    public Contact getContact() {
        return this.customer != null ? this.customerRules.getSMSContact(this.customer) : null;
    }

    public Party getLocation() {
        Party location = (Party)this.bean.getTarget(LOCATION, Party.class);
        if (location == null && this.customer != null) {
            location = (Party)this.service.getBean((IMObject)this.customer).getTarget(PRACTICE, Party.class);
        }
        return location;
    }

    public void sent(Date nextReminder) {
        Date now = new Date();
        if (this.reminder == null) {
            this.createReminder(now);
        }
        this.reminder.setValue(END_TIME, (Object)nextReminder);
        this.reminder.setValue(STATUS, (Object)"COMPLETED");
        this.bean.setValue(REMINDER_COUNT, (Object)this.count);
        this.bean.setValue(REMINDER_SENT, (Object)now);
        this.reminder.setValue(PROCESSED, (Object)now);
        this.toSave.add(this.bean.getObject());
        this.toSave.add(this.reminder.getObject());
        this.service.save(this.toSave);
        this.status = Status.SENT;
    }

    public void cancel() {
        if (this.reminder != null) {
            log.info("Cancelling reminder for charge={}, customer={}, count={}", new Object[]{this.bean.getObject().getId(), this.getCustomerId(), this.count});
            this.reminder.setValue(STATUS, (Object)"CANCELLED");
            this.toSave.add(this.reminder.getObject());
            this.service.save(this.toSave);
            this.status = Status.CANCELLED;
        } else {
            this.status = Status.SKIPPED;
        }
    }

    public boolean failed(String error) {
        return this.failed(error, false);
    }

    public boolean failed(String error, boolean forceLog) {
        log.info("Failed to send account reminder for charge={}, customer={}, count={}: {}", new Object[]{this.bean.getObject().getId(), this.getCustomerId(), this.count, error});
        boolean result = false;
        Date now = new Date();
        if (this.reminder == null && forceLog) {
            this.createReminder(now);
        }
        if (this.reminder != null) {
            int maxLength = this.reminder.getMaxLength(ERROR);
            this.reminder.setValue(STATUS, (Object)"ERROR");
            this.reminder.setValue(ERROR, (Object)StringUtils.abbreviate((String)error, (int)maxLength));
            this.reminder.setValue(PROCESSED, (Object)now);
            this.toSave.add(this.reminder.getObject());
            this.service.save(this.toSave);
            result = true;
            this.status = Status.ERROR;
        } else {
            this.status = Status.SKIPPED;
        }
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    private long getCustomerId() {
        Reference ref;
        long result = this.customer != null ? this.customer.getId() : ((ref = this.bean.getTargetRef(CUSTOMER)) != null ? ref.getId() : -1L);
        return result;
    }

    private IMObjectBean init() {
        IMObjectBean result = null;
        List reminders = this.bean.getTargets(REMINDERS, Act.class);
        for (Act act : reminders) {
            IMObjectBean reminder = this.service.getBean((IMObject)act);
            int existing = reminder.getInt(COUNT);
            if (existing == this.count) {
                result = reminder;
                continue;
            }
            if (existing >= this.count || !"PENDING".equals(act.getStatus()) && !"ERROR".equals(act.getStatus())) continue;
            act.setStatus("CANCELLED");
            this.toSave.add((IMObject)act);
        }
        return result;
    }

    private void createReminder(Date startTime) {
        Act act = (Act)this.service.create("act.customerChargeReminderSMS", Act.class);
        this.reminder = this.service.getBean((IMObject)act);
        this.reminder.setValue(START_TIME, (Object)startTime);
        this.reminder.setValue(COUNT, (Object)this.count);
        this.toSave.add((IMObject)act);
        this.toSave.add(this.bean.getObject());
        this.bean.addTarget(REMINDERS, (IMObject)act, CHARGE);
    }

    public static enum Status {
        UNKNOWN,
        SENT,
        SKIPPED,
        ERROR,
        CANCELLED;


        boolean isPersistent() {
            return this == SENT || this == ERROR || this == CANCELLED;
        }
    }
}

