/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.pharmacy;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.event.Listener;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.beans.factory.DisposableBean;

public class PharmacyOrderDiscontinuationScheduler
implements DisposableBean {
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final PracticeRules rules;
    private final Listener<PracticeService.Update> listener;
    private Period period;
    private static final Log log = LogFactory.getLog(PharmacyOrderDiscontinuationScheduler.class);

    public PharmacyOrderDiscontinuationScheduler(IArchetypeService service, PracticeService practiceService, PracticeRules rules) {
        this.service = service;
        this.practiceService = practiceService;
        this.rules = rules;
        Party practice = practiceService.getPractice();
        if (practice != null) {
            this.init(practice);
        } else {
            log.error((Object)"Pharmacy Order discontinuation cannot be enabled until a Practice is configured");
        }
        this.listener = update -> this.init(update.getPractice());
        practiceService.addListener(this.listener);
    }

    public void destroy() {
        this.practiceService.removeListener(this.listener);
    }

    private void init(Party practice) {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            log.error((Object)"Pharmacy Order discontinuation cannot be enabled until a Practice Service User is configured");
        } else {
            RunAs.run((User)user, () -> this.init(practice, user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Party practice, User user) {
        Period newPeriod = this.rules.getPharmacyOrderDiscontinuePeriod(practice);
        if (newPeriod == null) {
            this.disable();
        } else {
            Period current;
            PharmacyOrderDiscontinuationScheduler pharmacyOrderDiscontinuationScheduler = this;
            synchronized (pharmacyOrderDiscontinuationScheduler) {
                current = this.period;
            }
            if (!Objects.equals(current, newPeriod)) {
                this.enable(user, newPeriod);
            }
            pharmacyOrderDiscontinuationScheduler = this;
            synchronized (pharmacyOrderDiscontinuationScheduler) {
                this.period = newPeriod;
            }
        }
    }

    private void enable(User user, Period period) {
        IMObject config;
        IMObjectQueryIterator<IMObject> active = this.getJobs(true);
        if (active.hasNext()) {
            config = (IMObject)active.next();
        } else {
            IMObjectQueryIterator<IMObject> inactive = this.getJobs(false);
            if (inactive.hasNext()) {
                config = (IMObject)inactive.next();
                config.setActive(true);
            } else {
                config = this.service.create("entity.jobPharmacyOrderDiscontinuation");
            }
        }
        int total = period.toStandardMinutes().getMinutes();
        int totalDiv2 = total / 2;
        if (totalDiv2 < 5) {
            totalDiv2 = 5;
        }
        int hours = totalDiv2 / 60;
        int minutes = totalDiv2 - hours * 60;
        IMObjectBean bean = this.service.getBean(config);
        if (config.isNew()) {
            bean.setTarget("runAs", (IMObject)user);
        }
        if (minutes != 0) {
            bean.setValue("minutes", (Object)("*/" + minutes));
        } else {
            bean.setValue("minutes", (Object)"0");
        }
        if (hours == 0) {
            bean.setValue("hours", (Object)"*");
        } else {
            bean.setValue("hours", (Object)("*/" + hours));
        }
        this.service.save(config);
        log.info((Object)("Pharmacy order discontinuation is scheduled to occur every " + totalDiv2 + " minutes for invoices that have been finalised for " + total + " minutes"));
    }

    private void disable() {
        IMObjectQueryIterator<IMObject> iterator = this.getJobs(true);
        try {
            while (iterator.hasNext()) {
                IMObject object = (IMObject)iterator.next();
                if (!object.isActive()) continue;
                this.setActive(object, false);
            }
            log.info((Object)"Pharmacy order discontinuation is set to occur at invoice finalisation");
        }
        catch (Throwable exception) {
            log.error((Object)"Failed to disable job", exception);
        }
    }

    private void setActive(IMObject object, boolean active) {
        object.setActive(active);
        this.service.save(object);
    }

    private IMObjectQueryIterator<IMObject> getJobs(boolean active) {
        ArchetypeQuery query = new ArchetypeQuery("entity.jobPharmacyOrderDiscontinuation", active);
        query.setMaxResults(-1);
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }
}

