/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.pharmacy;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.scheduler.SingletonJob;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.pharmacy.OrderDiscontinuer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PharmacyOrderDiscontinuationJob
implements InterruptableJob,
SingletonJob {
    private final Entity configuration;
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final OrderDiscontinuer discontinuer;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    static final String JOB_ARCHETYPE = "entity.jobPharmacyOrderDiscontinuation";
    private static final Log log = LogFactory.getLog(PharmacyOrderDiscontinuationJob.class);
    private static final int DEFAULT_MAX_RECORDS = 1000;
    private static final int DEFAULT_BATCH_SIZE = 100;

    public PharmacyOrderDiscontinuationJob(Entity configuration, IArchetypeRuleService service, PracticeService practiceService, OrderDiscontinuer discontinuer) {
        this.configuration = configuration;
        this.service = service;
        this.practiceService = practiceService;
        this.discontinuer = discontinuer;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        long begin = System.currentTimeMillis();
        int processed = 0;
        try {
            Date time = this.discontinueBefore();
            processed = this.discontinue(time, this.practiceService.getServiceUser());
            this.complete(null, processed, begin);
        }
        catch (Throwable exception) {
            log.error((Object)exception, exception);
            this.complete(exception, processed, begin);
        }
    }

    private int discontinue(Date time, User user) {
        int maxRecords;
        IMObjectBean bean;
        int batchSize;
        int count = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("PharmacyOrderDiscontinuationJob discontinuing orders associated with invoices on or before: " + DateFormatter.formatDateTime((Date)time)));
        }
        if ((batchSize = (bean = this.service.getBean((IMObject)this.configuration)).getInt("batchSize", 100)) <= 0) {
            batchSize = 100;
        }
        if ((maxRecords = bean.getInt("maxRecords", 1000)) <= 0) {
            maxRecords = 1000;
        }
        boolean done = false;
        while (!this.stop && !done) {
            int updated = this.discontinue(time, batchSize, user);
            if (updated >= batchSize && (count += updated) < maxRecords) continue;
            done = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PharmacyOrderDiscontinuationJob processed=" + count));
        }
        return count;
    }

    private int discontinue(Date time, int batchSize, User user) {
        SoftRefIMObjectCache cache = new SoftRefIMObjectCache((ArchetypeService)this.service);
        List<FinancialAct> invoices = this.discontinuer.getInvoices(time, batchSize);
        Party practice = this.practiceService.getPractice();
        for (FinancialAct invoice : invoices) {
            this.discontinuer.discontinue(invoice, user, practice, (IMObjectCache)cache);
        }
        return invoices.size();
    }

    private void complete(Throwable exception, int locked, long begin) {
        Set<User> users;
        long endTime = System.currentTimeMillis();
        long elapsed = endTime - begin;
        if (!(exception == null && locked == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, locked, elapsed, exception);
        }
    }

    private void notifyUsers(Set<User> users, int locked, long elapsed, Throwable exception) {
        String text;
        String subject;
        String reason;
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"pharmacyorderjob.exception.subject", (Object[])new Object[]{this.configuration.getName()});
            text = Messages.format((String)"pharmacyorderjob.exception.message", (Object[])new Object[]{exception.getMessage()});
        } else {
            reason = "COMPLETED";
            double seconds = (double)elapsed / 1000.0;
            double rate = seconds != 0.0 ? (double)locked / seconds : (double)locked;
            subject = Messages.format((String)"pharmacyorderjob.subject", (Object[])new Object[]{this.configuration.getName(), locked});
            text = Messages.format((String)"pharmacyorderjob.message", (Object[])new Object[]{locked, seconds, rate});
        }
        this.notifier.send(users, subject, reason, text);
    }

    private Date discontinueBefore() {
        Period period = this.practiceService.getPharmacyOrderDiscontinuePeriod();
        if (period == null) {
            period = Period.ZERO;
        }
        return new DateTime().minus((ReadablePeriod)period).toDate();
    }
}

