/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.pharmacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.customer.charge.OrderPlacer;
import org.openvpms.web.workspace.customer.charge.OrderServices;

public class OrderDiscontinuer {
    private final OrderServices orderServices;
    private final IArchetypeService service;
    private static final Log log = LogFactory.getLog(OrderDiscontinuer.class);

    public OrderDiscontinuer(OrderServices orderServices, IArchetypeService service) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalArgumentException("Argument 'service' must have rules disabled");
        }
        this.orderServices = orderServices;
        this.service = service;
    }

    public void discontinue(FinancialAct invoice, User user, Party practice, IMObjectCache cache) {
        ArrayList<Act> items = new ArrayList<Act>();
        IMObjectBean bean = this.service.getBean((IMObject)invoice);
        for (Act item : bean.getTargets("items", Act.class)) {
            if (!"ORDERED".equals(item.getStatus())) continue;
            items.add(item);
        }
        if (!items.isEmpty()) {
            Party customer = (Party)bean.getTarget("customer", Party.class);
            Party location = (Party)bean.getTarget("location", Party.class);
            if (log.isDebugEnabled()) {
                String custName = customer != null ? customer.getName() + "(" + customer.getId() + ")" : null;
                Date endTime = invoice.getActivityEndTime();
                String date = endTime != null ? DateFormatter.formatDateTime((Date)endTime, (boolean)false) : null;
                log.debug((Object)("Discontinuing orders for invoice=" + invoice.getId() + ", POSTED at " + date + " for customer=" + custName));
            }
            if (customer != null && location != null) {
                OrderPlacer placer = new OrderPlacer(customer, location, user, practice, cache, this.orderServices, (ArchetypeService)this.service);
                placer.initialise(items);
                placer.discontinue(Collections.emptyList());
            }
            for (Act item : items) {
                item.setStatus("DISCONTINUED");
            }
            this.service.save(items);
        }
    }

    public List<FinancialAct> getInvoices(Date time, int batchSize) {
        CriteriaBuilder cb = this.service.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(FinancialAct.class).distinct(true);
        Root root = criteriaQuery.from(FinancialAct.class, new String[]{"act.customerAccountChargesInvoice"}).alias("invoice");
        Join item = root.join("items").join("target", "act.customerAccountInvoiceItem").alias("item");
        item.on((Expression)cb.equal((Expression)item.get("status"), (Object)"ORDERED"));
        criteriaQuery.where(new Predicate[]{cb.equal((Expression)root.get("status"), (Object)"POSTED"), cb.lessThanOrEqualTo((Expression)root.get("endTime"), (Comparable)time)});
        TypedQuery query = this.service.createQuery(criteriaQuery);
        query.setMaxResults(batchSize);
        return query.getResultList();
    }
}

