/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import java.util.Date;
import org.openvpms.web.jobs.docload.email.EmailLoaderListener;
import org.slf4j.Logger;

class LoggingEmailLoaderListener
extends EmailLoaderListener {
    private final Logger log;

    public LoggingEmailLoaderListener(Logger log) {
        this.log = log;
    }

    @Override
    public void loaded(String messageId, String from, String subject, Date date, String name, long id) {
        super.loaded(messageId, from, subject, date, name, id);
        this.log.info("Loaded attachment from messageId={}, from={}, subject={}, date={}, name={}, to id={}", new Object[]{messageId, from, subject, date, name, id});
    }

    @Override
    public void alreadyLoaded(String messageId, String from, String subject, Date date, String name, long id) {
        super.alreadyLoaded(messageId, from, subject, date, name, id);
        this.log.info("Skipped attachment from messageId={}, from={}, subject={}, date={}, name={}, to id={}", new Object[]{messageId, from, subject, date, name, id});
    }

    @Override
    public void missingId(String messageId, String from, String subject, Date date, String name) {
        super.missingId(messageId, from, subject, date, name);
        this.log.info("Missing id for messageId={}, from={}, subject={}, date={}, name={}", new Object[]{messageId, from, subject, date, name});
    }

    @Override
    public void missingAct(String messageId, String from, String subject, Date date, String name, long id) {
        super.missingAct(messageId, from, subject, date, name, id);
        this.log.info("Missing act for messageId={}, from={}, subject={}, date={}, name={}, id={}", new Object[]{messageId, from, subject, date, name, id});
    }

    @Override
    public void noAttachment(String messageId, String from, String subject, Date date) {
        super.noAttachment(messageId, from, subject, date);
        this.log.info("Email has no attachments for messageId={}, from={}, subject={}, date={}", new Object[]{messageId, from, subject, date});
    }

    @Override
    public void error(String messageId, String from, String subject, Date date, String name, Throwable exception) {
        super.error(messageId, from, subject, date, name, exception);
        this.log.info("Error for messageId={}, from={}, subject={}, date={}, name={}, id={}: {}", new Object[]{messageId, from, subject, date, name, exception.getMessage(), exception});
    }

    @Override
    public void error(String messageId, String from, String subject, Date date, String name, String message) {
        super.error(messageId, from, subject, date, name, message);
        this.log.info("Error for messageId={}, from={}, subject={}, date={}, name={}: {}", new Object[]{messageId, from, subject, date, name, message});
    }
}

