/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.jobs.docload.email.EmailFolderLoader;
import org.openvpms.web.jobs.docload.email.EmailLoader;
import org.openvpms.web.jobs.docload.email.EmailLoaderListener;
import org.openvpms.web.jobs.docload.email.LoggingEmailLoaderListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

@DisallowConcurrentExecution
public class EmailDocumentLoaderJob
implements InterruptableJob {
    private final Entity configuration;
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final DocumentHandlers handlers;
    private final DocumentRules rules;
    private final MailPasswordResolver passwordResolver;
    private final JobCompletionNotifier notifier;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private static final Logger log = LoggerFactory.getLogger(EmailDocumentLoaderJob.class);

    public EmailDocumentLoaderJob(Entity configuration, IArchetypeRuleService service, PlatformTransactionManager transactionManager, DocumentHandlers handlers, DocumentRules rules, MailPasswordResolver passwordResolver) {
        this.configuration = configuration;
        this.service = service;
        this.transactionManager = transactionManager;
        this.handlers = handlers;
        this.rules = rules;
        this.passwordResolver = passwordResolver;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        EmailLoaderListener listener;
        MailServer server = new MailServer(this.configuration, this.service);
        IMObjectBean bean = this.service.getBean((IMObject)this.configuration);
        List<String> from = this.getFrom(bean);
        Pattern idPattern = Pattern.compile(bean.getString("idPattern"));
        String sourceFolder = bean.getString("sourceFolder");
        String targetFolder = bean.getString("targetFolder");
        String errorFolder = bean.getString("errorFolder");
        boolean logLoad = bean.getBoolean("log");
        EmailLoaderListener emailLoaderListener = listener = logLoad ? new LoggingEmailLoaderListener(log) : new EmailLoaderListener();
        if (logLoad) {
            log.info("Loading attachments from {}@{}:{} using pattern={}, sourceFolder={}, targetFolder={}, errorFolder={}", new Object[]{server.getUsername(), server.getHost(), server.getPort(), idPattern, sourceFolder, targetFolder, errorFolder});
        }
        EmailLoader loader = this.createLoader(idPattern, listener);
        EmailFolderLoader folderLoader = new EmailFolderLoader(server, this.passwordResolver, listener);
        this.stop.set(false);
        try {
            folderLoader.process(loader, from, sourceFolder, targetFolder, errorFolder, this.stop);
            this.complete(listener, null);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(listener, exception);
        }
    }

    public void interrupt() {
        this.stop.set(true);
    }

    protected EmailLoader createLoader(Pattern idPattern, EmailLoaderListener listener) {
        return new EmailLoader(idPattern, this.service, this.transactionManager, this.handlers, this.rules, listener);
    }

    protected void complete(EmailLoaderListener listener, Throwable exception) {
        Set<User> users;
        if (!(listener.getProcessed() == 0 && exception == null || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(listener, exception, users);
        }
    }

    protected void notifyUsers(Set<User> users, String subject, String reason, String text) {
        this.notifier.send(users, subject, reason, text);
    }

    private void notifyUsers(EmailLoaderListener listener, Throwable exception, Set<User> users) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"emaildocload.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"emaildocload.exception", (Object[])new Object[]{exception.getMessage()}));
        } else {
            int loaded = listener.getLoaded().size();
            int errors = listener.getMissingId().size() + listener.getMissingAct().size() + listener.getErrors().size();
            if (errors != 0) {
                reason = "ERROR";
                subject = Messages.format((String)"emaildocload.subject.errors", (Object[])new Object[]{this.configuration.getName(), errors});
            } else {
                reason = "COMPLETED";
                subject = Messages.format((String)"emaildocload.subject.success", (Object[])new Object[]{this.configuration.getName(), loaded});
            }
        }
        this.append(text, listener.getErrors(), "emaildocload.error", "emaildocload.error.item");
        this.append(text, listener.getMissingId(), "emaildocload.missingId", "emaildocload.missingId.item");
        this.append(text, listener.getMissingAct(), "emaildocload.missingAct", "emaildocload.missingAct.item");
        this.append(text, listener.getAlreadyLoaded(), "emaildocload.alreadyLoaded", "emaildocload.alreadyLoaded.item");
        this.append(text, listener.getNoAttachments(), "emaildocload.noAttachment", "emaildocload.noAttachment.item");
        this.append(text, listener.getLoaded(), "emaildocload.loaded", "emaildocload.loaded.item");
        this.notifyUsers(users, subject, reason, text.toString());
    }

    private void append(StringBuilder text, List<EmailLoaderListener.MailData> attachments, String headingKey, String itemKey) {
        if (!attachments.isEmpty()) {
            if (text.length() != 0) {
                text.append("\n\n");
            }
            text.append(Messages.get((String)headingKey));
            text.append("\n");
            for (EmailLoaderListener.MailData attachment : attachments) {
                String date = attachment.getDate() != null ? DateFormatter.formatDateTime((Date)attachment.getDate(), (boolean)true) : "";
                text.append(Messages.format((String)itemKey, (Object[])new Object[]{attachment.getId(), StringUtils.defaultString((String)attachment.getName(), (String)"(unknown)"), StringUtils.defaultString((String)attachment.getFrom(), (String)"(unknown)"), StringUtils.defaultString((String)attachment.getSubject(), (String)"(none)"), date, StringUtils.defaultString((String)attachment.getError(), (String)"(none)")}));
                text.append("\n");
            }
        }
    }

    private List<String> getFrom(IMObjectBean bean) {
        ArrayList<String> result = new ArrayList<String>();
        for (String value : bean.getString("from", "").split(",")) {
            if ((value = StringUtils.trimToNull((String)value)) == null) continue;
            result.add(value);
        }
        return result;
    }
}

